package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging;


import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing user profile related resource messages
 */
public interface EventProducer {

    /**
     * Publishes an Event message for created resource.
     *
     * @param eventDto the resource that was created
     */
    void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message for updated resource.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message for deleted resource.
     *
     * @param eventDto the resource that was deleted
     */
    void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message when user updates the CV.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateCVEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message when user updates the image.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateImageEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message when user updates the language.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateLanguageEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message to notify users when any other resource is created that matches their interests.
     *
     * @param eventDto the resource that was updated
     */
    void publishInterestsEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message to notify users when any catalog resource is created that matches their interests.
     *
     * @param eventDto the resource that was updated
     */
    void publishCatalogInterestsEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message to notify user on receiving an endorsement for an expertise
     *
     * @param eventDto the resource that was updated
     */
    void publishEndorsementEvent(@NonNull MessagingEventDto<?> eventDto);

}
