package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging;

import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * Message Producer responsible for publishing user-profile related resource messages
 */
public interface ResourceProducer {

    /**
     * Filter key used to identify the service in the message metadata.
     */
    String SERVICE_FILTER_KEY = "service";
    /**
     * Filter value associated with the userProfile service.
     */
    String SERVICE_FILTER_VALUE = "userProfile";

    /**
     * Publishes a message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreatedResource(@NonNull OutputUserProfileDto resource);

    /**
     * Publishes a message for updated resource.
     *
     * @param resource the resource that was updated
     */
    void publishUpdatedResource(@NonNull OutputUserProfileDto resource);

    /**
     * Publishes a message for updated resources.
     *
     * @param resources that were updated
     */
    void publishUpdatedResources(@NonNull List<OutputUserProfileDto> resources);

    /**
     * Publishes a message for deleted resource.
     *
     * @param resource the resource that was deleted
     */
    void publishDeletedResource(@NonNull OutputUserProfileDto resource);
}
