package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto;

import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

@Data
@Builder
public class JoinRequestStatusChangeNotificationData {

    /**
     * Whether the request was approved by the WP lead
     * Approval status (true = approved, false = rejected)
     */
    private Boolean approved;

    /**
     * Context or details about the decision
     */
    private String message;

    /**
     * Ids of the requesting users
     */
    private List<UUID> requestingUsers;

    /**
     * Root institutional page UUID
     */
    private UUID rootInstitutionalPageId;

    /**
     * Name of the root institutional page
     */
    private String rootInstitutionalPageName;

    /**
     * Member user IDs to notify
     */
    private List<UUID> notifyUserIds;
}