package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link EventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerEventProducer implements EventProducer {

    @Override
    public void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", eventDto);
    }

    @Override
    public void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - UPDATED event for resource: {}", eventDto);
    }

    @Override
    public void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - DELETED event for resource: {}", eventDto);
    }

    @Override
    public void publishUpdateCVEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CV UPDATED event for resource: {}", eventDto);
    }

    @Override
    public void publishUpdateImageEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - IMAGE UPDATED event for resource: {}", eventDto);
    }

    @Override
    public void publishUpdateLanguageEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - LANGUAGE UPDATED event for resource: {}", eventDto);
    }

    @Override
    public void publishInterestsEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - INTERESTS event for resource: {}", eventDto);
    }

    @Override
    public void publishCatalogInterestsEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CATALOG INTERESTS event for resource: {}", eventDto);
    }

    @Override
    public void publishEndorsementEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - Endorsement event for resource: {}", eventDto);
    }
}