package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.ResourceProducer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Local stub implementation of {@link ResourceProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Component
@Slf4j
public class LoggerResourceProducer implements ResourceProducer {
    @Override
    public void publishCreatedResource(@NonNull OutputUserProfileDto resource) {
        log.info("Message dispatch skipped (messaging disabled) - CREATED event for resource: {}", resource);
    }

    @Override
    public void publishUpdatedResource(@NonNull OutputUserProfileDto resource) {
        log.info("Message dispatch skipped (messaging disabled) - UPDATED event for resource: {}", resource);
    }

    @Override
    public void publishUpdatedResources(@NonNull List<OutputUserProfileDto> resources) {
        log.info("Message dispatch skipped (messaging disabled) - UPDATED events for resources: {}", resources);
    }

    @Override
    public void publishDeletedResource(@NonNull OutputUserProfileDto resource) {
        log.info("Message dispatch skipped (messaging disabled) - DELETED event for resource: {}", resource);
    }
}