package com.finconsgroup.itserr.marketplace.userprofile.bs.openapi;

import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * Overridden Operation Service implementation to expose hidden API operations
 * based on application configuration.
 */
@Component
@Primary
public class OpenApiOperationService extends OperationService {

    private final boolean exposeHidden;

    public OpenApiOperationService(GenericParameterService parameterBuilder,
                                   RequestBodyService requestBodyService,
                                   SecurityService securityParser,
                                   PropertyResolverUtils propertyResolverUtils,
                                   @Value("${user-profile.bs.swagger-api-expose-hidden:false}") boolean exposeHidden) {
        super(parameterBuilder, requestBodyService, securityParser, propertyResolverUtils);
        this.exposeHidden = exposeHidden;
    }

    @Override
    public boolean isHidden(Method method) {
        // expose hidden operations based on application configuration
        if (this.exposeHidden) {
            return false;
        }

        return super.isHidden(method);
    }
}
