/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputAdminPatchUserProfileDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="AdminApi", description="API for managing user profiles")
@SecurityRequirement(name="BearerAuth")
public interface AdminApi {
    @Operation(summary="patch a user profile by ID", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PatchMapping(value={"/admin/profile/{profileId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputAdminPatchUserProfileDto patchUserProfile(@PathVariable(value="profileId") UUID var1, @RequestBody InputAdminPatchUserProfileDto var2);

    @Operation(summary="publish resource messages for all user profiles", responses={@ApiResponse(responseCode="204", description="No Content")})
    @PostMapping(value={"/admin/profiles/publish"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void publishAllProfilesMessages();
}

