/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputEndorsementAcknowledgementDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Endorsement", description="The Endorsement API: it provides endpoints for endorsing expertise.")
@SecurityRequirement(name="BearerAuth")
public interface EndorsementApi {
    @Operation(summary="Endorse a user's expertise", description="Adds an endorsement to a user's specific expertise by expertise ID.", responses={@ApiResponse(responseCode="200", description="Endorsement added successfully"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="404", description="User profile or expertise not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/profiles/{profileId}/expertise/{expertiseId}/confirm"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputEndorsementAcknowledgementDto addEndorsement(@PathVariable(value="profileId") UUID var1, @PathVariable(value="expertiseId") UUID var2);

    @Operation(summary="Delete an existing endorsement", description="Adds an endorsement to a user's specific expertise by expertise ID.", responses={@ApiResponse(responseCode="200", description="Endorsement deleted successfully"), @ApiResponse(responseCode="404", description="User profile or expertise not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @DeleteMapping(value={"/profiles/{profileId}/expertise/{expertiseId}/confirm"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeEndorsement(@PathVariable(value="profileId") UUID var1, @PathVariable(value="expertiseId") UUID var2);
}

