/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserSettingDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="UserProfile", description="API for managing user profiles")
@SecurityRequirement(name="BearerAuth")
public interface UserProfileApi {
    @Operation(summary="create userprofile for the authenticated user", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="409", description="Another metadata exists with the same name", content={@Content}), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content})})
    @PostMapping(value={"/profile"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputUserProfileDto create(@Valid @RequestBody InputUserProfileDto var1);

    @Operation(summary="update userprofile by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/profile"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUserProfileDto updateById(@Valid @RequestBody InputUpdateUserProfileDto var1);

    @Operation(summary="Upload the profile image of a user by ID", responses={@ApiResponse(responseCode="200", description="Profile image updated"), @ApiResponse(responseCode="404", description="Profile not found")})
    @PostMapping(value={"/profile/image"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public URI uploadImage(@RequestPart(value="file") MultipartFile var1);

    @Operation(summary="Upload the profile CV of a user by ID", responses={@ApiResponse(responseCode="200", description="CV updated"), @ApiResponse(responseCode="404", description="Profile not found")})
    @PostMapping(value={"/profile/cv"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public URI uploadCv(@RequestPart(value="file") MultipartFile var1);

    @Operation(summary="Change the preferred language of an existing user", responses={@ApiResponse(responseCode="200", description="Language updated"), @ApiResponse(responseCode="404", description="Profile not found")})
    @PutMapping(value={"/profile/language/{language}"}, produces={"application/json"})
    public OutputUserSettingDto updateLanguage(@PathVariable(value="language") String var1);

    @Operation(summary="get user profiles by role name", responses={@ApiResponse(responseCode="200", description="OK")}, hidden=true)
    @GetMapping(value={"/profiles-by-role"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> getUserProfilesByRole(@NotBlank @RequestParam(value="roleName") String var1);

    @Operation(summary="activate a user profile by ID", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/profile/activate"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void activate();

    @Operation(summary="deactivate a user profile by ID", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @DeleteMapping(value={"/profile/activate"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deactivate();

    @Operation(summary="Change the home panel options of an existing user", responses={@ApiResponse(responseCode="200", description="Panel flag updated"), @ApiResponse(responseCode="404", description="Profile not found")})
    @PutMapping(value={"/profile/hidePanel/{hidePanel}"}, produces={"application/json"})
    public Boolean updateHidePanel(@PathVariable(value="hidePanel") Boolean var1);
}

