/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterests;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterestsApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileInterestsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class MessagingUserProfileInterestsApplicationEventListener
implements ApplicationListener<UserProfileInterestsApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingUserProfileInterestsApplicationEventListener.class);
    private final EventProducer eventProducer;
    private final UserProfileMapper userProfileMapper;

    public void onApplicationEvent(@NonNull UserProfileInterestsApplicationEvent event) {
        MessagingEventDto messagingEventDto = this.userProfileMapper.toMessagingEventDto(event.getUserProfileInterests());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        UserProfileInterests userProfileInterests = event.getUserProfileInterests();
        messagingEventDto.setTimestamp(userProfileInterests.getTimestamp());
        UserProfileInterestsMessagingAdditionalDataDto additionalData = new UserProfileInterestsMessagingAdditionalDataDto();
        additionalData.setDescription(userProfileInterests.getDescription());
        additionalData.setNotifyUserIds(userProfileInterests.getNotifyUserIds());
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.eventProducer.publishInterestsEvent(messagingEventDto);
    }

    @Generated
    public MessagingUserProfileInterestsApplicationEventListener(EventProducer eventProducer, UserProfileMapper userProfileMapper) {
        this.eventProducer = eventProducer;
        this.userProfileMapper = userProfileMapper;
    }
}

