/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputFindUserProfilesByInterestsDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.MessagingCatalogBsProperties;
import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.UserProfileBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileInterestsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.CatalogItemMessagingStatusAdditionalDataDto;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="catalogEventConsumer")
public class CatalogEventConsumer
extends CloudEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogEventConsumer.class);
    private static final String OPERATION_TYPE_CREATE = "create";
    private static final String STATUS_APPROVED = "approved";
    private final UserProfileDmClient userProfileDmClient;
    private final EventProducer eventProducer;

    public CatalogEventConsumer(UserProfileBsConfigurationProperties userProfileBsConfigurationProperties, UserProfileDmClient userProfileDmClient, EventProducer eventProducer) {
        super(new CloudEventTypeHandler[0]);
        MessagingCatalogBsProperties messagingCatalogBsProperties = userProfileBsConfigurationProperties.getMessaging().getCatalogBs();
        this.addHandler(messagingCatalogBsProperties.getResourceStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleResourceStatusChange(arg_0, arg_1));
        this.userProfileDmClient = userProfileDmClient;
        this.eventProducer = eventProducer;
    }

    private void handleResourceStatusChange(MessagingEventDto<CatalogItemMessagingStatusAdditionalDataDto> eventPayload, CloudEvent cloudEvent) {
        CatalogItemMessagingStatusAdditionalDataDto data = (CatalogItemMessagingStatusAdditionalDataDto)eventPayload.getAdditionalData();
        if (STATUS_APPROVED.equalsIgnoreCase(eventPayload.getStatus()) && OPERATION_TYPE_CREATE.equalsIgnoreCase(data.getOperationType())) {
            ArrayList<String> matchingInterestsToCheck = new ArrayList<String>(Optional.ofNullable(data.getTags()).orElse(List.of()));
            matchingInterestsToCheck.add(eventPayload.getTitle());
            matchingInterestsToCheck.add(data.getContent());
            List userProfileIdsWithInterests = this.userProfileDmClient.findMatchingInterests(InputFindUserProfilesByInterestsDto.builder().stringsToCheck(matchingInterestsToCheck).build());
            if (userProfileIdsWithInterests == null || userProfileIdsWithInterests.isEmpty()) {
                return;
            }
            MessagingEventDto messagingEventDto = new MessagingEventDto();
            messagingEventDto.setId(eventPayload.getId());
            messagingEventDto.setUser(eventPayload.getUser());
            messagingEventDto.setName(eventPayload.getName());
            messagingEventDto.setTitle(eventPayload.getTitle());
            messagingEventDto.setCategory(eventPayload.getCategory());
            messagingEventDto.setStatus(eventPayload.getStatus());
            messagingEventDto.setMessage(eventPayload.getMessage());
            messagingEventDto.setTimestamp(eventPayload.getTimestamp());
            UserProfileInterestsMessagingAdditionalDataDto additionalData = new UserProfileInterestsMessagingAdditionalDataDto();
            additionalData.setNotifyUserIds(new HashSet(userProfileIdsWithInterests));
            messagingEventDto.setAdditionalData((Object)additionalData);
            this.eventProducer.publishCatalogInterestsEvent(messagingEventDto);
        }
    }
}

