/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAddProjectToUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputPatchUserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputRemoveProjectFromUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.MessagingInstitutionalPageBsProperties;
import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.UserProfileBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.InstitutionalPageEventConsumer;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.EventDataWrapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.JoinRequestStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.MemberInvitationStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.MembershipChangeNotificationData;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto.MembershipRemovalNotificationData;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.enums.OperationType;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.helper.MessagingHelper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="institutionalPageEventConsumer")
public class InstitutionalPageEventConsumer
extends CloudEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageEventConsumer.class);
    private final UserProfileService userProfileService;
    private final MessagingHelper messagingHelper;
    private final String resourceStatusChangeEventType;

    public InstitutionalPageEventConsumer(UserProfileBsConfigurationProperties userProfileBsConfigurationProperties, UserProfileService userProfileService, MessagingHelper messagingHelper) {
        super(new CloudEventTypeHandler[0]);
        MessagingInstitutionalPageBsProperties messagingInstitutionalPageBsProperties = userProfileBsConfigurationProperties.getMessaging().getInstitutionalPageBs();
        this.addHandler(messagingInstitutionalPageBsProperties.getResourceStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleResourceStatusChange(arg_0, arg_1));
        this.addHandler(messagingInstitutionalPageBsProperties.getJoinRequestStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleJoinRequestStatusChange(arg_0, arg_1));
        this.addHandler(messagingInstitutionalPageBsProperties.getMemberInvitationStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleInvitationStatusChange(arg_0, arg_1));
        this.addHandler(messagingInstitutionalPageBsProperties.getMembershipChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleMembershipChange(arg_0, arg_1));
        this.addHandler(messagingInstitutionalPageBsProperties.getMembershipRemovalEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleMembershipRemoval(arg_0, arg_1));
        this.userProfileService = userProfileService;
        this.messagingHelper = messagingHelper;
        this.resourceStatusChangeEventType = messagingInstitutionalPageBsProperties.getResourceStatusChangeEventType();
    }

    private void handleResourceStatusChange(UntypedMessagingEventDto resourcePayload, CloudEvent cloudEvent) {
        InstitutionalPageStatusChangeNotificationData data = this.messagingHelper.convertToInstitutionalPageStatusChangeNotificationData(resourcePayload.getAdditionalData());
        this.processUserGroups(cloudEvent.getType(), data.getCurrentWpLeaders(), resourcePayload, data, true);
        this.processUserGroups(cloudEvent.getType(), data.getCurrentMembers(), resourcePayload, data, false);
    }

    private void processUserGroups(String eventType, List<UUID> userIds, UntypedMessagingEventDto resourcePayload, InstitutionalPageStatusChangeNotificationData data, boolean isWpLeader) {
        if (!userIds.isEmpty()) {
            EventDataWrapper eventDataWrapper = new EventDataWrapper(resourcePayload, eventType, data, userIds, Boolean.valueOf(isWpLeader));
            this.processApprovedEvent(eventDataWrapper);
        }
    }

    private void handleJoinRequestStatusChange(UntypedMessagingEventDto resourcePayload, CloudEvent cloudEvent) {
        JoinRequestStatusChangeNotificationData data = this.messagingHelper.convertToJoinRequestStatusChangeNotificationData(resourcePayload.getAdditionalData());
        if (!data.getRequestingUsers().isEmpty()) {
            EventDataWrapper eventDataWrapper = new EventDataWrapper(resourcePayload, cloudEvent.getType(), data, data.getRequestingUsers(), Boolean.valueOf(false));
            this.processApprovedEvent(eventDataWrapper);
        }
    }

    private void handleInvitationStatusChange(UntypedMessagingEventDto resourcePayload, CloudEvent cloudEvent) {
        MemberInvitationStatusChangeNotificationData data = this.messagingHelper.convertToMemberInvitationStatusChangeNotificationData(resourcePayload.getAdditionalData());
        if (data.getInvitedUser() != null) {
            EventDataWrapper eventDataWrapper = new EventDataWrapper(resourcePayload, cloudEvent.getType(), data, List.of(data.getInvitedUser()), data.getWpLeader());
            this.processApprovedEvent(eventDataWrapper);
        }
    }

    private void handleMembershipChange(UntypedMessagingEventDto resourcePayload, CloudEvent cloudEvent) {
        MembershipChangeNotificationData data = this.messagingHelper.convertToMembershipChangeNotificationData(resourcePayload.getAdditionalData());
        UUID userId = data.getMemberUserId();
        EventDataWrapper eventDataWrapper = new EventDataWrapper(resourcePayload, cloudEvent.getType(), data, List.of(userId), data.getWpLeader());
        if (Boolean.TRUE.equals(data.getWpLeader())) {
            this.addWpLeaderToProjectHierarchy(userId, eventDataWrapper);
        } else {
            this.removeWpLeaderFromProjectHierarchy(userId, eventDataWrapper);
        }
    }

    private void handleMembershipRemoval(UntypedMessagingEventDto resourcePayload, CloudEvent cloudEvent) {
        MembershipRemovalNotificationData data = this.messagingHelper.convertToMembershipRemovalNotificationData(resourcePayload.getAdditionalData());
        if (Boolean.TRUE.equals(data.getWpLeader())) {
            data.getHierarchyInstitutionalPages().keySet().forEach(institutionalPageId -> {
                InputRemoveProjectFromUserProfilesDto removeDto = this.messagingHelper.buildInputRemoveProjectFromUserProfilesDto(institutionalPageId, List.of(data.getMemberUserId()));
                this.userProfileService.removeProjectFromUserProfiles(removeDto);
            });
        } else {
            InputRemoveProjectFromUserProfilesDto removeDto = this.messagingHelper.buildInputRemoveProjectFromUserProfilesDto(UUID.fromString(resourcePayload.getId()), List.of(data.getMemberUserId()));
            this.userProfileService.removeProjectFromUserProfiles(removeDto);
        }
    }

    private void processApprovedEvent(EventDataWrapper eventDataWrapper) {
        if (!Boolean.TRUE.equals(eventDataWrapper.getApproved())) {
            log.debug("Event Request not approved for processing, id: {}, type: {}", (Object)eventDataWrapper.getResourceId(), (Object)eventDataWrapper.getEventType());
            return;
        }
        if (this.resourceStatusChangeEventType.equals(eventDataWrapper.getEventType())) {
            this.handleStatusChangeOperation(eventDataWrapper);
        } else {
            this.handleEventsAsPerMembership(eventDataWrapper);
        }
    }

    private void handleStatusChangeOperation(EventDataWrapper eventDataWrapper) {
        OperationType operationType = eventDataWrapper.getOperationType();
        if (operationType == null) {
            log.warn("No operation type in event wrapper for resourceId: {}", (Object)eventDataWrapper.getResourceId());
            return;
        }
        switch (6.$SwitchMap$com$finconsgroup$itserr$marketplace$userprofile$bs$messaging$enums$OperationType[operationType.ordinal()]) {
            case 1: {
                this.userProfileService.addProjectToUserProfiles(this.messagingHelper.buildInputAddProjectToUserProfilesDto(eventDataWrapper));
                break;
            }
            case 2: {
                this.userProfileService.removeProjectFromUserProfiles(this.messagingHelper.buildInputRemoveProjectFromUserProfilesDto(eventDataWrapper));
                break;
            }
            default: {
                log.debug("Unsupported operation type: {} for resourceId: {}", (Object)operationType, (Object)eventDataWrapper.getResourceId());
            }
        }
    }

    private void handleEventsAsPerMembership(EventDataWrapper eventDataWrapper) {
        if (Boolean.TRUE.equals(eventDataWrapper.getWpLeader())) {
            eventDataWrapper.getUserIds().forEach(userId -> this.addWpLeaderToProjectHierarchy(userId, eventDataWrapper));
        } else {
            InputAddProjectToUserProfilesDto addDto = this.messagingHelper.buildInputAddProjectToUserProfilesDto(eventDataWrapper);
            this.userProfileService.addProjectToUserProfiles(addDto);
        }
    }

    private void addWpLeaderToProjectHierarchy(UUID userId, EventDataWrapper eventDataWrapper) {
        Map hierarchyInstitutionalPages = eventDataWrapper.getHierarchyInstitutionalPages();
        OutputUserProfileDto userProfile = this.userProfileService.getById(userId);
        List<UUID> existingProjectIds = userProfile.getProjects().stream().map(OutputProjectDto::getProjectId).filter(hierarchyInstitutionalPages::containsKey).toList();
        if (!existingProjectIds.isEmpty()) {
            InputPatchUserProfileProjectDto patchDto = this.messagingHelper.buildInputPatchUserProfileProjectDto(existingProjectIds, List.of(userId), Boolean.valueOf(true));
            this.userProfileService.patchUserProfileProject(patchDto);
        }
        List<UUID> projectIdsToAdd = hierarchyInstitutionalPages.keySet().stream().filter(projectId -> !existingProjectIds.contains(projectId)).toList();
        for (UUID projectId2 : projectIdsToAdd) {
            String projectName = (String)hierarchyInstitutionalPages.get(projectId2);
            InputAddProjectToUserProfilesDto inputAddProjectToUserProfilesDto = this.messagingHelper.buildInputAddProjectToUserProfilesDto(projectId2, projectName, userId, eventDataWrapper.getRootInstitutionalPageId(), eventDataWrapper.getRootInstitutionalPageName(), Boolean.valueOf(true));
            this.userProfileService.addProjectToUserProfiles(inputAddProjectToUserProfilesDto);
        }
    }

    private void removeWpLeaderFromProjectHierarchy(UUID userId, EventDataWrapper eventDataWrapper) {
        OutputUserProfileDto userProfile = this.userProfileService.getById(userId);
        List<UUID> projectInHierarchy = userProfile.getProjects().stream().filter(project -> project.getRootProjectId().equals(eventDataWrapper.getRootInstitutionalPageId())).map(OutputProjectDto::getProjectId).toList();
        for (UUID projectId : projectInHierarchy) {
            if (projectId.equals(eventDataWrapper.getRootInstitutionalPageId())) {
                InputPatchUserProfileProjectDto patchDto = this.messagingHelper.buildInputPatchUserProfileProjectDto(List.of(projectId), List.of(userId), Boolean.valueOf(false));
                this.userProfileService.patchUserProfileProject(patchDto);
                continue;
            }
            InputRemoveProjectFromUserProfilesDto inputRemoveProjectFromUserProfilesDto = InputRemoveProjectFromUserProfilesDto.builder().userIds(List.of(userId)).projectId(projectId).build();
            this.userProfileService.removeProjectFromUserProfiles(inputRemoveProjectFromUserProfilesDto);
        }
    }
}

