/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.UserProfileBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
@Component
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MessageProducer messageProducer;
    private final UserProfileBsConfigurationProperties.Messaging messagingProperties;

    public DefaultResourceProducer(UserProfileBsConfigurationProperties userProfileBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = userProfileBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishCreatedResource(@NonNull OutputUserProfileDto resource) {
        this.publish(Map.of(resource.getId().toString(), resource), this.messagingProperties.getResourceCreatedType());
    }

    public void publishUpdatedResource(@NonNull OutputUserProfileDto resource) {
        this.publish(Map.of(resource.getId().toString(), resource), this.messagingProperties.getResourceUpdatedType());
    }

    public void publishUpdatedResources(@NonNull List<OutputUserProfileDto> resources) {
        this.publish(this.toMessageMap(resources), this.messagingProperties.getResourceUpdatedType());
    }

    public void publishDeletedResource(@NonNull OutputUserProfileDto resource) {
        this.publish(Map.of(resource.getId().toString(), resource), this.messagingProperties.getResourceDeletedType());
    }

    private void publish(@NonNull Map<String, OutputUserProfileDto> messageMap, @NonNull String eventType) {
        try {
            Map<String, String> filterProperties = Map.of("service", "userProfile");
            log.debug("Sending message, messageMap: {}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource(s) with id(s):{}", messageMap.keySet());
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }

    private Map<String, OutputUserProfileDto> toMessageMap(List<OutputUserProfileDto> resources) {
        return resources.stream().collect(Collectors.toMap(resource -> resource.getId().toString(), resource -> resource));
    }
}

