/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.validation;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.validation.annotation.ValidInputCreateOrUpdateUserProfileDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class InputCreateOrUpdateUserProfileDtoValidator
implements ConstraintValidator<ValidInputCreateOrUpdateUserProfileDto, Object> {
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean valid = true;
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InputUserProfileDto.class, InputUpdateUserProfileDto.class}, (Object)object, n)) {
            case -1: {
                return valid;
            }
            case 0: {
                InputUserProfileDto inputUserProfileDto = (InputUserProfileDto)object;
                valid = this.validateExpertise(context, inputUserProfileDto.getExpertises());
                break;
            }
            case 1: {
                InputUpdateUserProfileDto inputUpdateUserProfileDto = (InputUpdateUserProfileDto)object;
                valid = this.validateExpertise(context, inputUpdateUserProfileDto.getExpertises());
                break;
            }
        }
        return valid;
    }

    private boolean validateExpertise(ConstraintValidatorContext context, List<InputExpertiseDto> inputExpertises) {
        if (inputExpertises == null) {
            return true;
        }
        boolean valid = true;
        HashSet<UUID> seen = new HashSet<UUID>();
        HashSet<UUID> duplicates = new HashSet<UUID>();
        for (InputExpertiseDto dto : inputExpertises) {
            UUID labelId = dto.getLabelId();
            if (labelId == null || seen.add(labelId)) continue;
            duplicates.add(labelId);
        }
        if (!duplicates.isEmpty()) {
            context.buildConstraintViolationWithTemplate("duplicate_expertise_label_ids_found: " + String.valueOf(duplicates)).addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

