/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ManualReferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.PublicationEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ReferenceEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="manual_reference")
public class ManualReferenceEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="reference_id", nullable=false)
    private ReferenceEntity reference;
    @Column(name="title")
    private String title;
    @Column(name="journal_or_conference")
    private String journalOrConference;
    @Column(name="url")
    private String url;
    @Column(name="volume")
    private String volume;
    @Column(name="pages")
    private String pages;
    @Column(name="paragraph")
    private String paragraph;
    @OneToMany(mappedBy="referenceDetails", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AuthorEntity> authors;
    @OneToOne(mappedBy="referenceDetails", cascade={CascadeType.ALL}, orphanRemoval=true)
    private PublicationEntity publication;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ManualReferenceEntity(ManualReferenceEntityBuilder<?, ?> b) {
        super(b);
        this.reference = b.reference;
        this.title = b.title;
        this.journalOrConference = b.journalOrConference;
        this.url = b.url;
        this.volume = b.volume;
        this.pages = b.pages;
        this.paragraph = b.paragraph;
        this.authors = b.authors;
        this.publication = b.publication;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ManualReferenceEntityBuilder<?, ?> builder() {
        return new ManualReferenceEntityBuilderImpl();
    }

    @Generated
    public ReferenceEntity getReference() {
        return this.reference;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getJournalOrConference() {
        return this.journalOrConference;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getVolume() {
        return this.volume;
    }

    @Generated
    public String getPages() {
        return this.pages;
    }

    @Generated
    public String getParagraph() {
        return this.paragraph;
    }

    @Generated
    public List<AuthorEntity> getAuthors() {
        return this.authors;
    }

    @Generated
    public PublicationEntity getPublication() {
        return this.publication;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setReference(ReferenceEntity reference) {
        this.reference = reference;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setJournalOrConference(String journalOrConference) {
        this.journalOrConference = journalOrConference;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Generated
    public void setPages(String pages) {
        this.pages = pages;
    }

    @Generated
    public void setParagraph(String paragraph) {
        this.paragraph = paragraph;
    }

    @Generated
    public void setAuthors(List<AuthorEntity> authors) {
        this.authors = authors;
    }

    @Generated
    public void setPublication(PublicationEntity publication) {
        this.publication = publication;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ManualReferenceEntity(reference=" + String.valueOf(this.getReference()) + ", title=" + this.getTitle() + ", journalOrConference=" + this.getJournalOrConference() + ", url=" + this.getUrl() + ", volume=" + this.getVolume() + ", pages=" + this.getPages() + ", paragraph=" + this.getParagraph() + ", authors=" + String.valueOf(this.getAuthors()) + ", publication=" + String.valueOf(this.getPublication()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManualReferenceEntity)) {
            return false;
        }
        ManualReferenceEntity other = (ManualReferenceEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$journalOrConference = this.getJournalOrConference();
        String other$journalOrConference = other.getJournalOrConference();
        if (this$journalOrConference == null ? other$journalOrConference != null : !this$journalOrConference.equals(other$journalOrConference)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$volume = this.getVolume();
        String other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        String this$pages = this.getPages();
        String other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !this$pages.equals(other$pages)) {
            return false;
        }
        String this$paragraph = this.getParagraph();
        String other$paragraph = other.getParagraph();
        if (this$paragraph == null ? other$paragraph != null : !this$paragraph.equals(other$paragraph)) {
            return false;
        }
        List this$authors = this.getAuthors();
        List other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        PublicationEntity this$publication = this.getPublication();
        PublicationEntity other$publication = other.getPublication();
        if (this$publication == null ? other$publication != null : !this$publication.equals(other$publication)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManualReferenceEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $journalOrConference = this.getJournalOrConference();
        result = result * 59 + ($journalOrConference == null ? 43 : $journalOrConference.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        String $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : $pages.hashCode());
        String $paragraph = this.getParagraph();
        result = result * 59 + ($paragraph == null ? 43 : $paragraph.hashCode());
        List $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        PublicationEntity $publication = this.getPublication();
        result = result * 59 + ($publication == null ? 43 : $publication.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ManualReferenceEntity() {
    }
}

