/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.WorkingLocationEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@Entity
@Table(name="working_location")
public class WorkingLocationEntity
extends AbstractUUIDEntity {
    @OneToOne
    @JoinColumn(name="user_profile_id", nullable=false)
    private UserProfileEntity userProfile;
    @Column(name="city")
    private String city;
    @Column(name="region")
    private String region;
    @Column(name="country")
    private String country;
    @Column(name="zipCode")
    private String zipCode;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected WorkingLocationEntity(WorkingLocationEntityBuilder<?, ?> b) {
        super(b);
        this.userProfile = b.userProfile;
        this.city = b.city;
        this.region = b.region;
        this.country = b.country;
        this.zipCode = b.zipCode;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static WorkingLocationEntityBuilder<?, ?> builder() {
        return new WorkingLocationEntityBuilderImpl();
    }

    @Generated
    public UserProfileEntity getUserProfile() {
        return this.userProfile;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getZipCode() {
        return this.zipCode;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserProfile(UserProfileEntity userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public void setCity(String city) {
        this.city = city;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "WorkingLocationEntity(userProfile=" + String.valueOf(this.getUserProfile()) + ", city=" + this.getCity() + ", region=" + this.getRegion() + ", country=" + this.getCountry() + ", zipCode=" + this.getZipCode() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkingLocationEntity)) {
            return false;
        }
        WorkingLocationEntity other = (WorkingLocationEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$zipCode = this.getZipCode();
        String other$zipCode = other.getZipCode();
        if (this$zipCode == null ? other$zipCode != null : !this$zipCode.equals(other$zipCode)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkingLocationEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $zipCode = this.getZipCode();
        result = result * 59 + ($zipCode == null ? 43 : $zipCode.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public WorkingLocationEntity() {
    }
}

