/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ManualReferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ReferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.converter.StringListConverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="reference")
public class ReferenceEntity
extends AbstractUUIDEntity {
    @OneToOne
    @JoinColumn(name="user_profile_id", nullable=false)
    private UserProfileEntity userProfile;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="dois")
    private List<String> dois;
    @OneToMany(mappedBy="reference", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ManualReferenceEntity> manualReferences;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ReferenceEntity(ReferenceEntityBuilder<?, ?> b) {
        super(b);
        this.userProfile = b.userProfile;
        this.dois = b.dois;
        this.manualReferences = b.manualReferences;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ReferenceEntityBuilder<?, ?> builder() {
        return new ReferenceEntityBuilderImpl();
    }

    @Generated
    public UserProfileEntity getUserProfile() {
        return this.userProfile;
    }

    @Generated
    public List<String> getDois() {
        return this.dois;
    }

    @Generated
    public List<ManualReferenceEntity> getManualReferences() {
        return this.manualReferences;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserProfile(UserProfileEntity userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public void setDois(List<String> dois) {
        this.dois = dois;
    }

    @Generated
    public void setManualReferences(List<ManualReferenceEntity> manualReferences) {
        this.manualReferences = manualReferences;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ReferenceEntity(userProfile=" + String.valueOf(this.getUserProfile()) + ", dois=" + String.valueOf(this.getDois()) + ", manualReferences=" + String.valueOf(this.getManualReferences()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceEntity)) {
            return false;
        }
        ReferenceEntity other = (ReferenceEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        List this$dois = this.getDois();
        List other$dois = other.getDois();
        if (this$dois == null ? other$dois != null : !((Object)this$dois).equals(other$dois)) {
            return false;
        }
        List this$manualReferences = this.getManualReferences();
        List other$manualReferences = other.getManualReferences();
        if (this$manualReferences == null ? other$manualReferences != null : !((Object)this$manualReferences).equals(other$manualReferences)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        List $dois = this.getDois();
        result = result * 59 + ($dois == null ? 43 : ((Object)$dois).hashCode());
        List $manualReferences = this.getManualReferences();
        result = result * 59 + ($manualReferences == null ? 43 : ((Object)$manualReferences).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ReferenceEntity() {
    }
}

