/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.zenodo;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.ZenodoClient;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.InputOauthTokenRequestDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.OutputOauthTokenDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoConfigurationProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoOauthProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.ZenodoAuthFailureException;
import java.net.URI;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ZenodoAuthenticator {
    private final ZenodoConfigurationProperties config;
    private final ZenodoClient zenodoClient;

    @NonNull
    public OutputOauthTokenDto getToken(@NonNull String authCode, @NonNull URI redirectUri) {
        ZenodoOauthProperties oauth = this.config.getOauth();
        try {
            return this.zenodoClient.getToken(InputOauthTokenRequestDto.builder().client_id(oauth.getClientId()).client_secret(oauth.getClientSecret()).grant_type("authorization_code").code(authCode).redirect_uri(redirectUri.toString()).build());
        }
        catch (Exception e) {
            throw new ZenodoAuthFailureException(e);
        }
    }

    @Generated
    public ZenodoAuthenticator(ZenodoConfigurationProperties config, ZenodoClient zenodoClient) {
        this.config = config;
        this.zenodoClient = zenodoClient;
    }
}

