/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public final class VFS {
    private static Boolean uriStyle;
    private static FileSystemManager instance;

    private VFS() {
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.createManager("org.apache.commons.vfs2.impl.StandardFileSystemManager");
        }
        return instance;
    }

    private static FileSystemManager createManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> mgrClass = Class.forName(managerClassName);
            FileSystemManager mgr = (FileSystemManager)mgrClass.newInstance();
            try {
                Method initMethod = mgrClass.getMethod("init", null);
                initMethod.invoke((Object)mgr, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return mgr;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public static boolean isUriStyle() {
        if (uriStyle == null) {
            uriStyle = Boolean.FALSE;
        }
        return uriStyle;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (VFS.uriStyle != null && VFS.uriStyle != uriStyle) {
            throw new IllegalStateException("URI STYLE ALREADY SET TO");
        }
        VFS.uriStyle = uriStyle ? Boolean.TRUE : Boolean.FALSE;
    }
}

