/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;

public class HdfsFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HdfsFileSystemConfigBuilder BUILDER = new HdfsFileSystemConfigBuilder();
    private static final String CONFIG_NAME = "config.name";

    private HdfsFileSystemConfigBuilder() {
        super("hdfs.");
    }

    public static HdfsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HdfsFileSystem.class;
    }

    public String getConfigName(FileSystemOptions opts) {
        return this.getString(opts, CONFIG_NAME);
    }

    public void setConfigName(FileSystemOptions opts, String name) {
        this.setParam(opts, CONFIG_NAME, name);
    }
}

