/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFile;

public class LocalFileSystem
extends AbstractFileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, null, opts);
        this.rootFile = rootFile;
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new LocalFile(this, this.rootFile, name);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DefaultLocalFileProvider.capabilities);
    }

    @Override
    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

