/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String name) {
        StringBuilder b = new StringBuilder(name);
        try {
            UriParser.fixSeparators(b);
            this.extractRootPrefix(name, b);
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuilder var2) throws FileSystemException;

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme(uri, name);
        if (scheme == null) {
            scheme = "file";
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        String rootFile = this.extractRootPrefix(uri, name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return this.createFileName(scheme, rootFile, path, fileType);
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

