/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.cache.FileSystemAndNameKey;
import org.apache.commons.vfs2.util.Messages;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private static final int TIMEOUT = 1000;
    private static final Log log = LogFactory.getLog(SoftRefFilesCache.class);
    private final ConcurrentMap<FileSystem, Map<FileName, Reference<FileObject>>> fileSystemCache = new ConcurrentHashMap<FileSystem, Map<FileName, Reference<FileObject>>>();
    private final Map<Reference<FileObject>, FileSystemAndNameKey> refReverseMap = new HashMap<Reference<FileObject>, FileSystemAndNameKey>(100);
    private final ReferenceQueue<FileObject> refQueue = new ReferenceQueue();
    private final AtomicReference<SoftRefReleaseThread> softRefReleaseThread = new AtomicReference();
    private final Lock lock = new ReentrantLock();

    private void startThread() {
        Thread newThread;
        Thread thread;
        do {
            newThread = null;
        } while ((thread = (Thread)this.softRefReleaseThread.get()) == null && this.softRefReleaseThread.compareAndSet(null, (SoftRefReleaseThread)(newThread = new SoftRefReleaseThread())));
        if (newThread != null) {
            newThread.start();
        }
    }

    private void endThread() {
        SoftRefReleaseThread thread = this.softRefReleaseThread.getAndSet(null);
        if (thread != null) {
            thread.requestEnd = true;
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFile(FileObject fileObject) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putFile: " + this.getSafeName(fileObject)));
        }
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
        FileSystemAndNameKey key = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
        this.lock.lock();
        try {
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, key);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getSafeName(FileName fileName) {
        return fileName.getFriendlyURI();
    }

    private String getSafeName(FileObject fileObject) {
        return this.getSafeName(fileObject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFileIfAbsent(FileObject fileObject) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putFile: " + this.getSafeName(fileObject)));
        }
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
        FileSystemAndNameKey key = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
        this.lock.lock();
        try {
            if (files.containsKey(fileObject.getName()) && files.get(fileObject.getName()).get() != null) {
                boolean bl = false;
                return bl;
            }
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, key);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Reference<FileObject> createReference(FileObject file, ReferenceQueue<FileObject> refqueue) {
        return new SoftReference<FileObject>(file, refqueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileSystem);
        this.lock.lock();
        try {
            Reference<FileObject> ref = files.get(fileName);
            if (ref == null) {
                FileObject fileObject = null;
                return fileObject;
            }
            FileObject fo = ref.get();
            if (fo == null) {
                this.removeFile(fileSystem, fileName);
            }
            FileObject fileObject = fo;
            return fileObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(FileSystem fileSystem) {
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileSystem);
        this.lock.lock();
        try {
            Iterator<FileSystemAndNameKey> iterKeys = this.refReverseMap.values().iterator();
            while (iterKeys.hasNext()) {
                FileSystemAndNameKey key = iterKeys.next();
                if (key.getFileSystem() != fileSystem) continue;
                iterKeys.remove();
                files.remove(key.getFileName());
            }
            if (files.size() < 1) {
                this.close(fileSystem);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void close(FileSystem fileSystem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("close fs: " + fileSystem.getRootName()));
        }
        this.fileSystemCache.remove(fileSystem);
        if (this.fileSystemCache.size() < 1) {
            this.endThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        this.endThread();
        this.lock.lock();
        try {
            this.fileSystemCache.clear();
            this.refReverseMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        if (this.removeFile(new FileSystemAndNameKey(fileSystem, fileName))) {
            this.close(fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFile(FileSystemAndNameKey key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeFile: " + this.getSafeName(key.getFileName())));
        }
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(key.getFileSystem());
        this.lock.lock();
        try {
            Reference<FileObject> ref = files.remove(key.getFileName());
            if (ref != null) {
                this.refReverseMap.remove(ref);
            }
            boolean bl = files.size() < 1;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<FileName, Reference<FileObject>> getOrCreateFilesystemCache(FileSystem fileSystem) {
        HashMap files;
        if (this.fileSystemCache.size() < 1) {
            this.startThread();
        }
        while ((files = (HashMap)this.fileSystemCache.get(fileSystem)) == null && this.fileSystemCache.putIfAbsent(fileSystem, files = new HashMap()) == null) {
        }
        return files;
    }

    private final class SoftRefReleaseThread
    extends Thread {
        private volatile boolean requestEnd;

        private SoftRefReleaseThread() {
            this.setName(SoftRefReleaseThread.class.getName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    Reference ref = SoftRefFilesCache.this.refQueue.remove(1000L);
                    if (ref == null) continue;
                    SoftRefFilesCache.this.lock.lock();
                    try {
                        FileSystemAndNameKey key = (FileSystemAndNameKey)SoftRefFilesCache.this.refReverseMap.get(ref);
                        if (key == null || !SoftRefFilesCache.this.removeFile(key)) continue;
                        SoftRefFilesCache.this.close(key.getFileSystem());
                    }
                    finally {
                        SoftRefFilesCache.this.lock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (this.requestEnd) break;
                    VfsLog.warn(SoftRefFilesCache.this.getLogger(), log, Messages.getString("vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }
}

