/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileSystem;

public final class FileSystemOptions
implements Cloneable {
    private final Map<FileSystemOptionKey, Object> options;

    public FileSystemOptions() {
        this(new TreeMap<FileSystemOptionKey, Object>());
    }

    protected FileSystemOptions(Map<FileSystemOptionKey, Object> options) {
        this.options = options;
    }

    void setOption(Class<? extends FileSystem> fileSystemClass, String name, Object value) {
        this.options.put(new FileSystemOptionKey(fileSystemClass, name), value);
    }

    Object getOption(Class<? extends FileSystem> fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.get(key);
    }

    boolean hasOption(Class<? extends FileSystem> fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.containsKey(key);
    }

    public int compareTo(FileSystemOptions other) {
        int hashFk;
        int propsFkSz;
        if (this == other) {
            return 0;
        }
        int propsSz = this.options == null ? 0 : this.options.size();
        int n = propsFkSz = other.options == null ? 0 : other.options.size();
        if (propsSz < propsFkSz) {
            return -1;
        }
        if (propsSz > propsFkSz) {
            return 1;
        }
        if (propsSz == 0) {
            return 0;
        }
        SortedMap<FileSystemOptionKey, Object> myOptions = this.options instanceof SortedMap ? (SortedMap)this.options : new TreeMap<FileSystemOptionKey, Object>(this.options);
        SortedMap<FileSystemOptionKey, Object> theirOptions = other.options instanceof SortedMap ? (SortedMap)other.options : new TreeMap<FileSystemOptionKey, Object>(other.options);
        Iterator<FileSystemOptionKey> optKeysIter = myOptions.keySet().iterator();
        Iterator<FileSystemOptionKey> otherKeysIter = theirOptions.keySet().iterator();
        while (optKeysIter.hasNext()) {
            int comp = optKeysIter.next().compareTo(otherKeysIter.next());
            if (comp == 0) continue;
            return comp;
        }
        Object[] array = new Object[propsSz];
        int hash = Arrays.deepHashCode(myOptions.values().toArray(array));
        if (hash < (hashFk = Arrays.deepHashCode(theirOptions.values().toArray(array)))) {
            return -1;
        }
        if (hash > hashFk) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.options == null) {
            result = 31 * result;
        } else {
            SortedMap<FileSystemOptionKey, Object> myOptions = this.options instanceof SortedMap ? (SortedMap)this.options : new TreeMap<FileSystemOptionKey, Object>(this.options);
            result = 31 * result + myOptions.keySet().hashCode();
            result = 31 * result + Arrays.deepHashCode(myOptions.values().toArray(new Object[this.options.size()]));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemOptions other = (FileSystemOptions)obj;
        return this.compareTo(other) == 0;
    }

    public Object clone() {
        return new FileSystemOptions(new TreeMap<FileSystemOptionKey, Object>(this.options));
    }

    public String toString() {
        return this.options.toString();
    }

    private static final class FileSystemOptionKey
    implements Comparable<FileSystemOptionKey> {
        private static final int HASH = 29;
        private final Class<? extends FileSystem> fileSystemClass;
        private final String name;

        private FileSystemOptionKey(Class<? extends FileSystem> fileSystemClass, String name) {
            this.fileSystemClass = fileSystemClass;
            this.name = name;
        }

        @Override
        public int compareTo(FileSystemOptionKey o) {
            int ret = this.fileSystemClass.getName().compareTo(o.fileSystemClass.getName());
            if (ret != 0) {
                return ret;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSystemOptionKey that = (FileSystemOptionKey)o;
            if (!this.fileSystemClass.equals(that.fileSystemClass)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.fileSystemClass.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

