/*
 *  Copyright 2012 GWT-Bootstrap
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.github.gwtbootstrap.client.ui.constants;


/**
 * Constants that do not belong to a group of similar values.
 * 
 * @since 2.0.4.0
 * 
 * @author Dominik Mayer
 */
public interface Constants {

	// General

	public static final String EMPTY_HREF = "javascript:;";

	public static final String ACTIVE = "active";

	public static final String DISABLED = "disabled";

	public static final String FADE = "fade";

	// Single use

    public static final String BADGE = "badge";

	public static final String BRAND = "brand";

	public static final String CARET = "caret";

	public static final String BTN = "btn";

	public static final String BTN_GROUP = "btn-group";

	public static final String BTN_TOOLBAR = "btn-toolbar";

	public static final String CONTAINER = "container";

	public static final String CONTAINER_FLUID = "container-fluid";

	public static final String DIVIDER = "divider";

	public static final String DIVIDER_VERTICAL = "divider-vertical";

	public static final String WELL = "well";

	public static final String LABEL = "label";

	public static final String MODAL_HEADER = "modal-header";

	public static final String MODAL_FOOTER = "modal-footer";

	public static final String ROW = "row";

	// Dropdown

	public static final String DROPUP = "dropup";

	public static final String DATA_TOGGLE = "data-toggle";

	// Alert

	public static final String ALERT = "alert";

	public static final String ALERT_BLOCK = "alert-block";

	public static final String ALERT_HEADING = "alert-heading";

	// Close

	public static final String CLOSE = "close";

	public static final String CLOSE_ICON = "&times;";

	public static final String DATA_DISMISS = "data-dismiss";

	// Column

	public static final String SPAN = "span";

	public static final String OFFSET = "offset";

	public static final int MINIMUM_SPAN_SIZE = 1;

	public static final int MAXIMUM_SPAN_SIZE = 12;

	// Table

	public static final String TABLE = "table";

	public static final String STRIPED = "striped";

	public static final String BORDERED = "bordered";

	public static final String CONDENSED = "condensed";

    public static final String HOVER = "hover";

	// Form controls
	public static final String CONTROL_GROUP = "control-group";

	public static final String CONTROL_LABEL = "control-label";

	public static final String CONTROLS = "controls";

	public static final String HELP_BLOCK = "help-block";

	public static final String HELP_INLINE = "help-inline";

	public static final String FORM_ACTIONS = "form-actions";
	
	public static final String PLACEHOLDER = "placeholder";
	
	public static final String CHECKBOX = "checkbox";
	
	public static final String RADIO = "radio";
	
	public static final String INLINE = "inline";
	
	// Buttons
	
	public static final String DATA_LOADING_TEXT = "data-loading-text";

	public static final String DATA_COMPLETE_TEXT = "data-complete-text";

	public static final String SEARCH_QUERY = "search-query";

	public static final String UNEDITABLE_INPUT = "uneditable-input";

	public static final String ADD_ON = "add-on";

	public static final String DATA_TARGET = "data-target";

    public static final String LEAD = "lead";

    public static final String UNSTYLED = "unstyled";

    public static final String CONTROLS_ROW = "controls-row";

    public static final String BTN_BLOCK = "btn-block";

    public static final String DROPDOWN_SUBMENU = "dropdown-submenu";

    public static final String BTN_GROUP_VERTICAL = "btn-group-vertical";

    public static final String BREADCRUMB = "breadcrumb";

    public static final String NAVBAR_INVERSE = "navbar-inverse";

    public static final String PREVIOUS = "previous";

    public static final String INITIALISM = "initialism";

    public static final String PRE_SCROLLABLE = "pre-scrollable";

    public static final String ROW_FLUID = "row-fluid";

    public static final String BAR = "bar";
    
    public static final String PROGRESS = "progress";

    public static final String THUMBNAILS = "thumbnails";

    public static final String THUMBNAIL = "thumbnail";

    public static final String CAPTION = "caption";

    public static final String ACCORDION = "accordion";

    public static final String ACCORDION_GROUP = "accordion-group";

    public static final String ACCORDION_HEADING = "accordion-heading";

    public static final String ACCORDION_BODY = "accordion-body";

    public static final String ACCORDION_INNER = "accordion-inner";

    public static final String COLLAPSE = "collapse";
    
    public static final String NAV_COLLAPSE = "nav-collapse " + COLLAPSE;
    
	public static final String NAV_COLLAPSE_TARGET = ".nav-collapse";

    public static final String IN = "in";

    public static final String ACCORDION_TOGGLE = "accordion-toggle";

    // Icons
    public static final String ICON_LIGHT = "icon-light";

    public static final String ICON_MUTED = "icon-muted";

    public static final String ICON_BORDER = "icon-border";

    public static final String ICON_STACK = "icon-stack";

    public static final String ICON_SPIN = "icon-spin";

    public static final String ICON_STACK_BASE = "icon-stack-base";

    // Input
    public static final String BLOCK_LEVEL = "input-block-level";
}
