/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternFlagsFactory {
    public static final int NO_FLAGS = -1;

    public int buildFlags(List<String> flags) {
        if (flags == null || flags.isEmpty()) {
            return -1;
        }
        int value = 0;
        for (String flag : flags) {
            value |= this.getValueOf(flag);
        }
        return value;
    }

    private int getValueOf(String flag) {
        if ("CANON_EQ".equalsIgnoreCase(flag)) {
            return 128;
        }
        if ("CASE_INSENSITIVE".equalsIgnoreCase(flag)) {
            return 2;
        }
        if ("COMMENTS".equalsIgnoreCase(flag)) {
            return 4;
        }
        if ("DOTALL".equalsIgnoreCase(flag)) {
            return 32;
        }
        if ("LITERAL".equalsIgnoreCase(flag)) {
            return 16;
        }
        if ("MULTILINE".equalsIgnoreCase(flag)) {
            return 8;
        }
        if ("UNICODE_CASE".equalsIgnoreCase(flag)) {
            return 64;
        }
        if ("UNIX_LINES".equalsIgnoreCase(flag)) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown regex flag: " + flag);
    }
}

