/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.TokenReplacer;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replacer {
    private final FileUtils fileUtils;
    private final TokenReplacer tokenReplacer;

    public Replacer(FileUtils fileUtils, TokenReplacer tokenReplacer) {
        this.fileUtils = fileUtils;
        this.tokenReplacer = tokenReplacer;
    }

    public void replace(List<Replacement> contexts, boolean regex, String file, String outputFile, int regexFlags) throws IOException {
        String content = this.fileUtils.readFile(file);
        for (Replacement context : contexts) {
            content = this.replaceContent(regex, regexFlags, content, context);
        }
        this.fileUtils.ensureFolderStructureExists(outputFile);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputFile));
        writer.write(content);
        ((Writer)writer).close();
    }

    private String replaceContent(boolean regex, int regexFlags, String content, Replacement context) {
        if (context.getToken() == null || context.getToken().trim().length() == 0) {
            throw new IllegalArgumentException("Token or token file required");
        }
        if (regex) {
            return this.tokenReplacer.replaceRegex(content, context.getToken(), context.getValue(), regexFlags);
        }
        return this.tokenReplacer.replaceNonRegex(content, context.getToken(), context.getValue());
    }

    public FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public TokenReplacer getTokenReplacer() {
        return this.tokenReplacer;
    }
}

