/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.PatternFlagsFactory;
import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.Replacer;
import com.google.code.maven_replacer_plugin.ReplacerFactory;
import com.google.code.maven_replacer_plugin.TokenReplacer;
import com.google.code.maven_replacer_plugin.TokenValueMapFactory;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import com.google.code.maven_replacer_plugin.include.FileSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacerMojo
extends AbstractMojo {
    private final FileUtils fileUtils;
    private final TokenReplacer tokenReplacer;
    private final ReplacerFactory replacerFactory;
    private final TokenValueMapFactory tokenValueMapFactory;
    private final FileSelector fileSelector;
    private final PatternFlagsFactory patternFlagsFactory;
    private String file;
    private List<String> includes;
    private List<String> excludes;
    private String filesToInclude;
    private String filesToExclude;
    private String token;
    private String tokenFile;
    private boolean ignoreMissingFile;
    private String value;
    private String valueFile;
    private boolean regex = true;
    private String outputFile;
    private String tokenValueMap;
    private String basedir = ".";
    private List<String> regexFlags;
    private List<Replacement> replacements;

    public ReplacerMojo() {
        this.fileUtils = new FileUtils();
        this.tokenReplacer = new TokenReplacer();
        this.replacerFactory = new ReplacerFactory(this.fileUtils, this.tokenReplacer);
        this.tokenValueMapFactory = new TokenValueMapFactory(this.fileUtils);
        this.fileSelector = new FileSelector();
        this.patternFlagsFactory = new PatternFlagsFactory();
    }

    public ReplacerMojo(FileUtils fileUtils, TokenReplacer tokenReplacer, ReplacerFactory replacerFactory, TokenValueMapFactory tokenValueMapFactory, FileSelector fileSelector, PatternFlagsFactory patternFlagsFactory) {
        this.fileUtils = fileUtils;
        this.tokenReplacer = tokenReplacer;
        this.replacerFactory = replacerFactory;
        this.tokenValueMapFactory = tokenValueMapFactory;
        this.fileSelector = fileSelector;
        this.patternFlagsFactory = patternFlagsFactory;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.ignoreMissingFile && this.fileUtils.fileNotExists(this.file)) {
                this.getLog().info((CharSequence)"Ignoring missing file");
                return;
            }
            Replacer replacer = this.replacerFactory.create();
            List<Replacement> contexts = this.getContexts();
            this.addIncludesFilesAndExcludedFiles();
            if (this.includes == null || this.includes.isEmpty()) {
                this.getOutputFile(this.file);
                this.replaceContents(replacer, contexts, this.file);
                return;
            }
            for (String file : this.fileSelector.listIncludes(this.basedir, this.includes, this.excludes)) {
                this.getOutputFile(file);
                this.replaceContents(replacer, contexts, file);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String getFilename(String file) {
        return this.basedir + '/' + file;
    }

    private void addIncludesFilesAndExcludedFiles() {
        String[] splitFiles;
        if (this.filesToInclude != null) {
            splitFiles = this.filesToInclude.split(",");
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            this.addToList(Arrays.asList(splitFiles), this.includes);
        }
        if (this.filesToExclude != null) {
            splitFiles = this.filesToExclude.split(",");
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            this.addToList(Arrays.asList(splitFiles), this.excludes);
        }
    }

    private void addToList(List<String> toAdds, List<String> destination) {
        for (String toAdd : toAdds) {
            destination.add(toAdd.trim());
        }
    }

    private void replaceContents(Replacer replacer, List<Replacement> contexts, String inputFile) throws IOException {
        this.getLog().info((CharSequence)("Replacing content in " + this.getFilename(inputFile)));
        replacer.replace(contexts, this.regex, this.getFilename(inputFile), this.getOutputFile(this.getFilename(inputFile)), this.patternFlagsFactory.buildFlags(this.regexFlags));
    }

    private List<Replacement> getContexts() throws IOException {
        if (this.replacements != null) {
            return this.replacements;
        }
        if (this.tokenValueMap == null) {
            Replacement context = new Replacement(this.fileUtils, this.token, this.value);
            context.setTokenFile(this.tokenFile);
            context.setValueFile(this.valueFile);
            return Arrays.asList(context);
        }
        return this.tokenValueMapFactory.contextsForFile(this.tokenValueMap);
    }

    private String getOutputFile(String file) {
        if (this.outputFile == null) {
            return file;
        }
        this.getLog().info((CharSequence)("Outputting to: " + this.getFilename(this.outputFile)));
        if (this.fileUtils.fileNotExists(file)) {
            this.fileUtils.ensureFolderStructureExists(this.getFilename(this.outputFile));
        }
        return this.getFilename(this.outputFile);
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
    }

    public void setValueFile(String valueFile) {
        this.valueFile = valueFile;
    }

    public void setIgnoreMissingFile(boolean ignoreMissingFile) {
        this.ignoreMissingFile = ignoreMissingFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setTokenValueMap(String tokenValueMap) {
        this.tokenValueMap = tokenValueMap;
    }

    public void setFilesToInclude(String filesToInclude) {
        this.filesToInclude = filesToInclude;
    }

    public void setFilesToExclude(String filesToExclude) {
        this.filesToExclude = filesToExclude;
    }

    public void setBasedir(String baseDir) {
        this.basedir = baseDir;
    }
}

