/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jeeunit;

import com.googlecode.jeeunit.ContainerLauncherLookup;
import com.googlecode.jeeunit.spi.ContainerLauncher;
import com.googlecode.jeeunit.spi.Injector;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JeeunitRunner
extends BlockJUnit4ClassRunner {
    private ContainerLauncher launcher;
    private WebResource testRunner;
    private boolean useDelegate;

    public JeeunitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        System.setProperty("java.util.logging.config.file", "src/test/resources/logging.properties");
        this.launcher = ContainerLauncherLookup.getContainerLauncher();
        this.launcher.launch();
        URI contextRoot = this.launcher.autodeploy();
        if (contextRoot != null) {
            this.useDelegate = true;
            this.testRunner = this.getTestRunner(contextRoot);
        }
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test;
        if (!this.useDelegate) {
            return super.methodBlock(method);
        }
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return JeeunitRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        return statement;
    }

    protected Statement methodInvoker(final FrameworkMethod method, Object test) {
        if (!this.useDelegate) {
            return super.methodInvoker(method, test);
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable result = JeeunitRunner.this.getRemoteTestResult(method);
                if (result != null) {
                    throw result;
                }
            }
        };
    }

    private Throwable getRemoteTestResult(FrameworkMethod method) throws IOException, ClassNotFoundException {
        InputStream is = (InputStream)this.testRunner.queryParam("class", this.getTestClass().getName()).queryParam("method", method.getName()).get(InputStream.class);
        ObjectInputStream ois = new ObjectInputStream(is);
        Object object = ois.readObject();
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        if (object instanceof String) {
            return null;
        }
        throw new IllegalStateException();
    }

    private WebResource getTestRunner(URI contextRoot) {
        URI uri = contextRoot.resolve("testrunner");
        Client client = Client.create();
        return client.resource(uri);
    }

    protected Object createTest() throws Exception {
        if (this.useDelegate) {
            return super.createTest();
        }
        Object test = super.createTest();
        this.inject(test);
        return test;
    }

    private void inject(Object test) {
        Injector injector = this.findInjector();
        injector.injectFields(test);
    }

    private Injector findInjector() {
        Iterator<Injector> it = ServiceLoader.load(Injector.class).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        throw new IllegalStateException("no Injector implementation found in META-INF/services");
    }
}

