/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jeeunit.impl;

import com.googlecode.jeeunit.impl.ContainerTestRunnerClassRequest;
import com.googlecode.jeeunit.spi.Injector;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public abstract class AbstractTestRunnerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String className = request.getParameter("class");
        String methodName = request.getParameter("method");
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            response.setContentType("application/octet-stream");
            ServletOutputStream os = response.getOutputStream();
            this.runSuite((OutputStream)os, clazz, methodName);
            os.flush();
        }
        catch (ClassNotFoundException exc) {
            throw new ServletException("cannot load test class " + className, (Throwable)exc);
        }
    }

    private void runSuite(OutputStream os, Class<?> clazz, String methodName) throws IOException {
        Injector injector = this.createInjector();
        ContainerTestRunnerClassRequest classRequest = new ContainerTestRunnerClassRequest(clazz, injector);
        Description method = Description.createTestDescription(clazz, (String)methodName);
        Request request = classRequest.filterWith(method);
        JUnitCore core = new JUnitCore();
        Result result = core.run(request);
        List failures = result.getFailures();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        for (Failure failure : failures) {
            oos.writeObject(failure.getException());
        }
        if (failures.isEmpty()) {
            oos.writeObject("ok");
        }
    }

    protected abstract Injector createInjector();
}

