/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query
extends Prepared {
    protected Expression limitExpr;
    protected Expression offsetExpr;
    protected int sampleSize;
    protected boolean distinct;
    protected boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private LocalResult lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;

    Query(Session session) {
        super(session);
    }

    protected abstract LocalResult queryWithoutCache(int var1, ResultTarget var2);

    public abstract void init();

    public abstract ArrayList<Expression> getExpressions();

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public abstract void setOrder(ArrayList<SelectOrderBy> var1);

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public void setRandomAccessResult(boolean bl) {
        this.randomAccessResult = bl;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l) {
        if (!this.cacheableChecked) {
            long l2 = this.getMaxDataModificationId();
            this.noCache = l2 == Long.MAX_VALUE;
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database database = session.getDatabase();
        for (int i = 0; i < valueArray.length; ++i) {
            if (database.areEqual(valueArray2[i], valueArray[i])) continue;
            return false;
        }
        if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return false;
        }
        return database.getModificationDataId() <= l || this.getMaxDataModificationId() <= l;
    }

    public final Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            arrayList = New.arrayList();
        }
        int n = arrayList.size();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Value value;
            valueArray[i] = value = arrayList.get(i).getParamValue();
        }
        return valueArray;
    }

    @Override
    public LocalResult query(int n) {
        return this.query(n, null);
    }

    LocalResult query(int n, ResultTarget resultTarget) {
        LocalResult localResult;
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults()) {
            return this.queryWithoutCache(n, resultTarget);
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && n == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = localResult = this.queryWithoutCache(n, resultTarget);
        this.lastEvaluated = l;
        this.lastLimit = n;
        return localResult;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, ArrayList<SelectOrderBy> arrayList3, int n, boolean bl, ArrayList<TableFilter> arrayList4) {
        Database database = session.getDatabase();
        for (SelectOrderBy selectOrderBy : arrayList3) {
            Object object;
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            boolean bl2 = false;
            int n2 = arrayList.size();
            if (expression instanceof ExpressionColumn) {
                object = (ExpressionColumn)expression;
                String string = ((ExpressionColumn)object).getOriginalTableAliasName();
                String string2 = ((ExpressionColumn)object).getOriginalColumnName();
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    Object object3;
                    Expression expression2;
                    boolean bl3 = false;
                    Expression expression3 = arrayList.get(i);
                    if (expression3 instanceof ExpressionColumn) {
                        expression2 = (ExpressionColumn)expression3;
                        bl3 = database.equalsIdentifiers(string2, ((ExpressionColumn)expression2).getColumnName());
                        if (bl3 && string != null) {
                            object3 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                            if (object3 == null) {
                                bl3 = false;
                                int n3 = arrayList4.size();
                                for (int j = 0; j < n3; ++j) {
                                    object2 = arrayList4.get(j);
                                    if (!database.equalsIdentifiers(((TableFilter)object2).getTableAlias(), string)) continue;
                                    bl3 = true;
                                    break;
                                }
                            } else {
                                bl3 = database.equalsIdentifiers((String)object3, string);
                            }
                        }
                    } else {
                        if (!(expression3 instanceof Alias)) continue;
                        if (string == null && database.equalsIdentifiers(string2, expression3.getAlias())) {
                            bl3 = true;
                        } else {
                            expression2 = expression3.getNonAliasExpression();
                            if (expression2 instanceof ExpressionColumn) {
                                object3 = expression2;
                                String string3 = ((ExpressionColumn)object).getSQL();
                                String string4 = ((ExpressionColumn)object3).getSQL();
                                object2 = ((ExpressionColumn)object3).getColumnName();
                                bl3 = database.equalsIdentifiers(string2, (String)object2);
                                if (!database.equalsIdentifiers(string3, string4)) {
                                    bl3 = false;
                                }
                            }
                        }
                    }
                    if (!bl3) continue;
                    n2 = i;
                    bl2 = true;
                    break;
                }
            } else {
                object = expression.getSQL();
                if (arrayList2 != null) {
                    int n4 = arrayList2.size();
                    for (int i = 0; i < n4; ++i) {
                        String string = arrayList2.get(i);
                        if (!database.equalsIdentifiers(string, (String)object)) continue;
                        n2 = i;
                        bl2 = true;
                        break;
                    }
                }
            }
            if (!bl2) {
                if (bl) {
                    throw DbException.get(90068, expression.getSQL());
                }
                arrayList.add(expression);
                object = expression.getSQL();
                arrayList2.add((String)object);
            }
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n2 + 1));
        }
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            SelectOrderBy selectOrderBy = arrayList.get(i);
            boolean bl = false;
            Expression expression = selectOrderBy.columnIndexExpr;
            Value value = expression.getValue(null);
            if (value == ValueNull.INSTANCE) {
                n4 = 0;
            } else {
                n4 = value.getInt();
                if (n4 < 0) {
                    bl = true;
                    n4 = -n4;
                }
                if (--n4 < 0 || n4 >= n) {
                    throw DbException.get(90068, "" + (n4 + 1));
                }
            }
            nArray[i] = n4;
            boolean bl2 = selectOrderBy.descending;
            if (bl) {
                bl2 = !bl2;
            }
            int n5 = n3 = bl2 ? 1 : 0;
            if (selectOrderBy.nullsFirst) {
                n3 += 2;
            } else if (selectOrderBy.nullsLast) {
                n3 += 4;
            }
            nArray2[i] = n3;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2);
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = New.arrayList();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return expressionVisitor.getMaxDataModificationId();
    }
}

