/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseForeignCollection<T, ID>
implements ForeignCollection<T>,
Serializable {
    private static final long serialVersionUID = -5158840898186237589L;
    protected final transient Dao<T, ID> dao;
    private final transient String columnName;
    private final transient Object parentId;
    private transient PreparedQuery<T> preparedQuery;
    private final transient String orderColumn;
    private final transient Object parent;

    protected BaseForeignCollection(Dao<T, ID> dao, Object parent, Object parentId, String columnName, String orderColumn) {
        this.dao = dao;
        this.columnName = columnName;
        this.parentId = parentId;
        this.orderColumn = orderColumn;
        this.parent = parent;
    }

    @Override
    public boolean add(T data) {
        if (this.dao == null) {
            return false;
        }
        try {
            this.dao.create(data);
            return true;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create data element in dao", e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.dao == null) {
            return false;
        }
        boolean changed = false;
        for (T data : collection) {
            try {
                this.dao.create(data);
                changed = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not create data elements in dao", e);
            }
        }
        return changed;
    }

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public abstract boolean removeAll(Collection<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.dao == null) {
            return false;
        }
        boolean changed = false;
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                Object data = iterator.next();
                if (collection.contains(data)) continue;
                iterator.remove();
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.dao == null) {
            return;
        }
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public int update(T data) throws SQLException {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.update(data);
    }

    @Override
    public int refresh(T data) throws SQLException {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.refresh(data);
    }

    protected PreparedQuery<T> getPreparedQuery() throws SQLException {
        if (this.dao == null) {
            return null;
        }
        if (this.preparedQuery == null) {
            SelectArg fieldArg = new SelectArg();
            fieldArg.setValue(this.parentId);
            QueryBuilder<T, ID> qb = this.dao.queryBuilder();
            if (this.orderColumn != null) {
                qb.orderBy(this.orderColumn, true);
            }
            this.preparedQuery = qb.where().eq(this.columnName, fieldArg).prepare();
            if (this.preparedQuery instanceof MappedPreparedStmt) {
                MappedPreparedStmt mappedStmt = (MappedPreparedStmt)this.preparedQuery;
                mappedStmt.setParentInformation(this.parent, this.parentId);
            }
        }
        return this.preparedQuery;
    }
}

