/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.LocalLog;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Logger;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static LogType logType;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        if (logType == null) {
            logType = LoggerFactory.findLogType();
        }
        return new Logger(logType.createLog(className));
    }

    public static String getSimpleClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length <= 1) {
            return className;
        }
        return parts[parts.length - 1];
    }

    private static LogType findLogType() {
        for (LogType logType : LogType.values()) {
            if (!logType.isAvailable()) continue;
            return logType;
        }
        return LogType.LOCAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LogType {
        ANDROID("android.util.Log", "com.j256.ormlite.android.AndroidLog"),
        COMMONS_LOGGING("org.apache.commons.logging.LogFactory", "com.j256.ormlite.logger.CommonsLoggingLog"),
        LOG4J("org.apache.log4j.Logger", "com.j256.ormlite.logger.Log4jLog"),
        LOCAL("com.j256.ormlite.logger.LocalLog", "com.j256.ormlite.logger.LocalLog"){

            public Log createLog(String classLabel) {
                return new LocalLog(classLabel);
            }

            public boolean isAvailable() {
                return true;
            }
        };

        private final String detectClassName;
        private final String logClassName;

        private LogType(String detectClassName, String logClassName) {
            this.detectClassName = detectClassName;
            this.logClassName = logClassName;
        }

        public Log createLog(String classLabel) {
            return this.createLogFromClassName(classLabel);
        }

        Log createLogFromClassName(String classLabel) {
            try {
                Class<?> clazz = Class.forName(this.logClassName);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                return (Log)constructor.newInstance(classLabel);
            }
            catch (Exception e) {
                LocalLog log = new LocalLog(classLabel);
                log.log(Log.Level.WARNING, "Unable to call constructor for class " + this.logClassName + ", so had to use local log", e);
                return log;
            }
        }

        public boolean isAvailable() {
            return this.isAvailableTestClass();
        }

        boolean isAvailableTestClass() {
            try {
                Class.forName(this.detectClassName);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

