/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.NeedsFutureClause;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyClause
implements Clause,
NeedsFutureClause {
    public static final String AND_OPERATION = "AND";
    public static final String OR_OPERATION = "OR";
    private final Clause first;
    private Clause second;
    private final Clause[] others;
    private final int startOthersAt;
    private final String operation;

    public ManyClause(Clause first, String operation) {
        this.first = first;
        this.second = null;
        this.others = null;
        this.startOthersAt = 0;
        this.operation = operation;
    }

    public ManyClause(Clause first, Clause second, Clause[] others, String operation) {
        this.first = first;
        this.second = second;
        this.others = others;
        this.startOthersAt = 0;
        this.operation = operation;
    }

    public ManyClause(Clause[] others, String operation) {
        this.first = others[0];
        if (others.length < 2) {
            this.second = null;
            this.startOthersAt = others.length;
        } else {
            this.second = others[1];
            this.startOthersAt = 2;
        }
        this.others = others;
        this.operation = operation;
    }

    @Override
    public void appendSql(DatabaseType databaseType, StringBuilder sb, List<ArgumentHolder> selectArgList) throws SQLException {
        sb.append("(");
        this.first.appendSql(databaseType, sb, selectArgList);
        if (this.second != null) {
            sb.append(this.operation);
            sb.append(' ');
            this.second.appendSql(databaseType, sb, selectArgList);
        }
        if (this.others != null) {
            for (int i = this.startOthersAt; i < this.others.length; ++i) {
                sb.append(this.operation);
                sb.append(' ');
                this.others[i].appendSql(databaseType, sb, selectArgList);
            }
        }
        sb.append(") ");
    }

    @Override
    public void setMissingClause(Clause right) {
        this.second = right;
    }
}

