/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.OrderBy;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private final FieldType idField;
    private FieldType[] resultFieldTypes;
    private boolean distinct = false;
    private boolean selectIdColumn = true;
    private List<String> selectColumnList = null;
    private List<String> selectRawList = null;
    private List<OrderBy> orderByList = null;
    private String orderByRaw = null;
    private List<String> groupByList = null;
    private String groupByRaw = null;
    private boolean isInnerQuery = false;
    private boolean countOf = false;
    private String having = null;
    private Long limit = null;
    private Long offset = null;

    public QueryBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.SELECT);
        this.idField = tableInfo.getIdField();
    }

    void enableInnerQuery() {
        this.isInnerQuery = true;
    }

    int getSelectColumnCount() {
        if (this.selectColumnList == null) {
            return 0;
        }
        return this.selectColumnList.size();
    }

    public PreparedQuery<T> prepare() throws SQLException {
        return super.prepareStatement(this.limit);
    }

    public QueryBuilder<T, ID> selectColumns(String ... columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectColumns(Iterable<String> columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectRaw(String ... columns) {
        if (this.selectRawList == null) {
            this.selectRawList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.selectRawList.add(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> groupBy(String columnName) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't groupBy foreign colletion field: " + columnName);
        }
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<String>();
        }
        this.groupByList.add(columnName);
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> groupByRaw(String rawSql) {
        this.groupByRaw = rawSql;
        return this;
    }

    public QueryBuilder<T, ID> orderBy(String columnName, boolean ascending) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't orderBy foreign colletion field: " + columnName);
        }
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(new OrderBy(columnName, ascending));
        return this;
    }

    public QueryBuilder<T, ID> orderByRaw(String rawSql) {
        this.orderByRaw = rawSql;
        return this;
    }

    public QueryBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> limit(int maxRows) {
        return this.limit(Long.valueOf(maxRows));
    }

    public QueryBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> offset(int startRow) throws SQLException {
        return this.offset(Long.valueOf(startRow));
    }

    public QueryBuilder<T, ID> offset(Long startRow) throws SQLException {
        if (this.databaseType.isOffsetSqlSupported()) {
            this.offset = startRow;
            return this;
        }
        throw new SQLException("Offset is not supported by this database");
    }

    public QueryBuilder<T, ID> setCountOf(boolean countOf) {
        this.countOf = countOf;
        return this;
    }

    public QueryBuilder<T, ID> having(String having) {
        this.having = having;
        return this;
    }

    public List<T> query() throws SQLException {
        return this.dao.query(this.prepare());
    }

    public T queryForFirst() throws SQLException {
        return this.dao.queryForFirst(this.prepare());
    }

    public String[] queryRawFirst() throws SQLException {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]).getFirstResult();
    }

    public CloseableIterator<T> iterator() throws SQLException {
        return this.dao.iterator(this.prepare());
    }

    @Override
    public void clear() {
        super.clear();
        this.distinct = false;
        this.selectIdColumn = true;
        this.selectColumnList = null;
        this.selectRawList = null;
        this.orderByList = null;
        this.orderByRaw = null;
        this.groupByList = null;
        this.groupByRaw = null;
        this.isInnerQuery = false;
        this.countOf = false;
        this.having = null;
        this.limit = null;
        this.offset = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) {
        sb.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        if (this.countOf) {
            this.type = StatementBuilder.StatementType.SELECT_LONG;
            sb.append("COUNT(*) ");
        } else if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            this.type = StatementBuilder.StatementType.SELECT_RAW;
            this.appendRawColumns(sb);
        } else {
            this.type = StatementBuilder.StatementType.SELECT;
            this.appendColumns(sb);
        }
        sb.append("FROM ");
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(' ');
    }

    @Override
    protected FieldType[] getResultFieldTypes() {
        return this.resultFieldTypes;
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb) throws SQLException {
        this.appendGroupBys(sb);
        this.appendOrderBys(sb);
        this.appendHaving(sb);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        this.appendOffset(sb);
    }

    private void addSelectColumnToList(String columnName) {
        this.verifyColumnName(columnName);
        this.selectColumnList.add(columnName);
    }

    private void appendRawColumns(StringBuilder sb) {
        boolean first = true;
        for (String column : this.selectRawList) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(' ');
    }

    private void appendColumns(StringBuilder sb) {
        if (this.selectColumnList == null) {
            sb.append("* ");
            this.resultFieldTypes = this.tableInfo.getFieldTypes();
            return;
        }
        boolean first = true;
        boolean hasId = this.isInnerQuery;
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>(this.selectColumnList.size() + 1);
        for (String columnName : this.selectColumnList) {
            FieldType fieldType = this.tableInfo.getFieldTypeByColumnName(columnName);
            if (fieldType.isForeignCollection()) {
                fieldTypeList.add(fieldType);
                continue;
            }
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, fieldType, fieldTypeList);
            if (fieldType != this.idField) continue;
            hasId = true;
        }
        if (!hasId && this.selectIdColumn) {
            if (!first) {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, this.idField, fieldTypeList);
        }
        sb.append(' ');
        this.resultFieldTypes = fieldTypeList.toArray(new FieldType[fieldTypeList.size()]);
    }

    private void appendFieldColumnName(StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        this.databaseType.appendEscapedEntityName(sb, fieldType.getColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(sb, this.limit, this.offset);
        }
    }

    private void appendOffset(StringBuilder sb) throws SQLException {
        if (this.offset == null) {
            return;
        }
        if (this.databaseType.isOffsetLimitArgument()) {
            if (this.limit == null) {
                throw new SQLException("If the offset is specified, limit must also be specified with this database");
            }
        } else {
            this.databaseType.appendOffsetValue(sb, this.offset);
        }
    }

    private void appendGroupBys(StringBuilder sb) {
        if ((this.groupByList == null || this.groupByList.isEmpty()) && this.groupByRaw == null) {
            return;
        }
        sb.append("GROUP BY ");
        if (this.groupByRaw != null) {
            sb.append(this.groupByRaw);
        } else {
            boolean first = true;
            for (String columnName : this.groupByList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                this.databaseType.appendEscapedEntityName(sb, columnName);
            }
        }
        sb.append(' ');
    }

    private void appendOrderBys(StringBuilder sb) {
        if ((this.orderByList == null || this.orderByList.isEmpty()) && this.orderByRaw == null) {
            return;
        }
        sb.append("ORDER BY ");
        if (this.orderByRaw != null) {
            sb.append(this.orderByRaw);
        } else {
            boolean first = true;
            for (OrderBy orderBy : this.orderByList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                String columnName = orderBy.getColumnName();
                this.databaseType.appendEscapedEntityName(sb, columnName);
                if (orderBy.isAscending()) continue;
                sb.append(" DESC");
            }
        }
        sb.append(' ');
    }

    private void appendHaving(StringBuilder sb) {
        if (this.having != null) {
            sb.append("HAVING ").append(this.having).append(' ');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalQueryBuilderWrapper {
        private final QueryBuilder<?, ?> queryBuilder;

        InternalQueryBuilderWrapper(QueryBuilder<?, ?> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
            this.queryBuilder.appendStatementString(sb, argList);
        }

        public FieldType[] getResultFieldTypes() {
            return ((QueryBuilder)this.queryBuilder).resultFieldTypes;
        }
    }
}

