/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectIterator<T, ID>
implements CloseableIterator<T> {
    private static final Logger logger = LoggerFactory.getLogger(SelectIterator.class);
    private final Class<?> dataClass;
    private final Dao<T, ID> classDao;
    private final ConnectionSource connectionSource;
    private final DatabaseConnection connection;
    private final CompiledStatement compiledStmt;
    private final DatabaseResults results;
    private final GenericRowMapper<T> rowMapper;
    private final String statement;
    private boolean first = true;
    private boolean closed = false;
    private boolean alreadyMoved = false;
    private T last = null;
    private int rowC = 0;

    public SelectIterator(Class<?> dataClass, Dao<T, ID> classDao, GenericRowMapper<T> rowMapper, ConnectionSource connectionSource, DatabaseConnection connection, CompiledStatement compiledStmt, String statement, ObjectCache objectCache) throws SQLException {
        this.dataClass = dataClass;
        this.classDao = classDao;
        this.rowMapper = rowMapper;
        this.connectionSource = connectionSource;
        this.connection = connection;
        this.compiledStmt = compiledStmt;
        this.results = compiledStmt.runQuery(objectCache);
        this.statement = statement;
        if (statement != null) {
            logger.debug("starting iterator @{} for '{}'", this.hashCode(), (Object)statement);
        }
    }

    public boolean hasNextThrow() throws SQLException {
        boolean result;
        if (this.closed) {
            return false;
        }
        if (this.alreadyMoved) {
            return true;
        }
        if (this.first) {
            this.first = false;
            result = this.results.first();
        } else {
            result = this.results.next();
        }
        if (!result) {
            this.close();
        }
        this.alreadyMoved = true;
        return result;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextThrow();
        }
        catch (SQLException e) {
            this.last = null;
            this.closeNoThrow();
            throw new IllegalStateException("Errors getting more results of " + this.dataClass, e);
        }
    }

    @Override
    public T first() throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.first()) {
            return this.getCurrent();
        }
        return null;
    }

    @Override
    public T previous() throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.previous()) {
            return this.getCurrent();
        }
        return null;
    }

    @Override
    public T current() throws SQLException {
        if (this.closed) {
            return null;
        }
        if (this.first) {
            return this.first();
        }
        return this.getCurrent();
    }

    @Override
    public T nextThrow() throws SQLException {
        if (this.closed) {
            return null;
        }
        if (!this.alreadyMoved) {
            boolean hasResult;
            if (this.first) {
                this.first = false;
                hasResult = this.results.first();
            } else {
                hasResult = this.results.next();
            }
            if (!hasResult) {
                this.first = false;
                return null;
            }
        }
        this.first = false;
        return this.getCurrent();
    }

    @Override
    public T next() {
        SQLException sqlException = null;
        try {
            T result = this.nextThrow();
            if (result != null) {
                return result;
            }
        }
        catch (SQLException e) {
            sqlException = e;
        }
        this.last = null;
        this.closeNoThrow();
        throw new IllegalStateException("Could not get next result for " + this.dataClass, sqlException);
    }

    @Override
    public T moveRelative(int offset) throws SQLException {
        if (this.closed) {
            return null;
        }
        this.first = false;
        if (this.results.moveRelative(offset)) {
            return this.getCurrent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThrow() throws SQLException {
        if (this.last == null) {
            throw new IllegalStateException("No last " + this.dataClass + " object to remove. Must be called after a call to next.");
        }
        if (this.classDao == null) {
            throw new IllegalStateException("Cannot remove " + this.dataClass + " object because classDao not initialized");
        }
        try {
            this.classDao.delete(this.last);
        }
        finally {
            this.last = null;
        }
    }

    @Override
    public void remove() {
        try {
            this.removeThrow();
        }
        catch (SQLException e) {
            this.closeNoThrow();
            throw new IllegalStateException("Could not delete " + this.dataClass + " object " + this.last, e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.compiledStmt.close();
            this.closed = true;
            this.last = null;
            if (this.statement != null) {
                logger.debug("closed iterator @{} after {} rows", this.hashCode(), (Object)this.rowC);
            }
            this.connectionSource.releaseConnection(this.connection);
        }
    }

    @Override
    public DatabaseResults getRawResults() {
        return this.results;
    }

    @Override
    public void moveToNext() {
        this.last = null;
        this.first = false;
        this.alreadyMoved = false;
    }

    private void closeNoThrow() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private T getCurrent() throws SQLException {
        this.last = this.rowMapper.mapRow(this.results);
        this.alreadyMoved = false;
        ++this.rowC;
        return this.last;
    }
}

