/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedPreparedStmt<T, ID>
extends BaseMappedQuery<T, ID>
implements PreparedQuery<T>,
PreparedDelete<T>,
PreparedUpdate<T> {
    private final ArgumentHolder[] argHolders;
    private final Long limit;
    private final StatementBuilder.StatementType type;

    public MappedPreparedStmt(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultFieldTypes, ArgumentHolder[] argHolders, Long limit, StatementBuilder.StatementType type) {
        super(tableInfo, statement, argFieldTypes, resultFieldTypes);
        this.argHolders = argHolders;
        this.limit = limit;
        this.type = type;
    }

    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection, StatementBuilder.StatementType type) throws SQLException {
        return this.compile(databaseConnection, type, -1);
    }

    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection, StatementBuilder.StatementType type, int resultFlags) throws SQLException {
        if (this.type != type) {
            throw new SQLException("Could not compile this " + (Object)((Object)this.type) + " statement since the caller is expecting a " + (Object)((Object)type) + " statement.  Check your QueryBuilder methods.");
        }
        CompiledStatement stmt = databaseConnection.compileStatement(this.statement, type, this.argFieldTypes, resultFlags);
        return this.compileStatement(databaseConnection, stmt);
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    @Override
    public StatementBuilder.StatementType getType() {
        return this.type;
    }

    @Override
    public void setArgumentHolderValue(int index, Object value) throws SQLException {
        if (index < 0) {
            throw new SQLException("argument holder index " + index + " must be >= 0");
        }
        if (this.argHolders.length <= index) {
            throw new SQLException("argument holder index " + index + " not valid, only " + this.argHolders.length + " in statement");
        }
        this.argHolders[index].setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledStatement compileStatement(DatabaseConnection databaseConnection, CompiledStatement stmt) throws SQLException {
        boolean ok = false;
        try {
            if (this.limit != null) {
                stmt.setMaxRows(this.limit.intValue());
            }
            Object[] argValues = null;
            if (logger.isLevelEnabled(Log.Level.TRACE) && this.argHolders.length > 0) {
                argValues = new Object[this.argHolders.length];
            }
            for (int i = 0; i < this.argHolders.length; ++i) {
                Object argValue = this.argHolders[i].getSqlArgValue();
                FieldType fieldType = this.argFieldTypes[i];
                SqlType sqlType = fieldType == null ? this.argHolders[i].getSqlType() : fieldType.getSqlType();
                stmt.setObject(i, argValue, sqlType);
                if (argValues == null) continue;
                argValues[i] = argValue;
            }
            logger.debug("prepared statement '{}' with {} args", (Object)this.statement, (Object)this.argHolders.length);
            if (argValues != null) {
                logger.trace("prepared statement arguments: {}", (Object)argValues);
            }
            ok = true;
            CompiledStatement compiledStatement = stmt;
            return compiledStatement;
        }
        finally {
            if (!ok) {
                stmt.close();
            }
        }
    }
}

