/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.query.BaseComparison;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSubQuery
extends BaseComparison {
    private final QueryBuilder.InternalQueryBuilderWrapper subQueryBuilder;
    private final boolean in;

    public InSubQuery(String columnName, FieldType fieldType, QueryBuilder.InternalQueryBuilderWrapper subQueryBuilder, boolean in) throws SQLException {
        super(columnName, fieldType, null, true);
        this.subQueryBuilder = subQueryBuilder;
        this.in = in;
    }

    @Override
    public void appendOperation(StringBuilder sb) {
        if (this.in) {
            sb.append("IN ");
        } else {
            sb.append("NOT IN ");
        }
    }

    @Override
    public void appendValue(DatabaseType databaseType, StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        sb.append('(');
        this.subQueryBuilder.appendStatementString(sb, argList);
        FieldType[] resultFieldTypes = this.subQueryBuilder.getResultFieldTypes();
        if (resultFieldTypes.length != 1) {
            throw new SQLException("There must be only 1 result column in sub-query but we found " + resultFieldTypes.length);
        }
        if (this.fieldType.getSqlType() != resultFieldTypes[0].getSqlType()) {
            throw new SQLException("Outer column " + this.fieldType + " is not the same type as inner column " + resultFieldTypes[0]);
        }
        sb.append(") ");
    }
}

