/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsLoggingLog
implements Log {
    private Object log;
    private static Method getLogMethod;
    private static Method isTraceEnabledMethod;
    private static Method isDebugEnabledMethod;
    private static Method isInfoEnabledMethod;
    private static Method isWarnEnabledMethod;
    private static Method isErrorEnabledMethod;
    private static Method isFatalEnabledMethod;
    private static Method traceMethod;
    private static Method traceThrowableMethod;
    private static Method debugMethod;
    private static Method debugThrowableMethod;
    private static Method infoMethod;
    private static Method infoThrowableMethod;
    private static Method warningMethod;
    private static Method warningThrowableMethod;
    private static Method errorMethod;
    private static Method errorThrowableMethod;
    private static Method fatalMethod;
    private static Method fatalThrowableMethod;

    public CommonsLoggingLog(String className) {
        if (getLogMethod == null) {
            CommonsLoggingLog.findMethods();
        }
        if (getLogMethod != null) {
            try {
                this.log = getLogMethod.invoke(null, className);
            }
            catch (Exception e) {
                this.log = null;
            }
        }
    }

    public boolean isLevelEnabled(Log.Level level) {
        switch (level) {
            case TRACE: {
                return this.isLevelEnabled(isTraceEnabledMethod);
            }
            case DEBUG: {
                return this.isLevelEnabled(isDebugEnabledMethod);
            }
            case INFO: {
                return this.isLevelEnabled(isInfoEnabledMethod);
            }
            case WARNING: {
                return this.isLevelEnabled(isWarnEnabledMethod);
            }
            case ERROR: {
                return this.isLevelEnabled(isErrorEnabledMethod);
            }
            case FATAL: {
                return this.isLevelEnabled(isFatalEnabledMethod);
            }
        }
        return this.isLevelEnabled(isInfoEnabledMethod);
    }

    public void log(Log.Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.logMessage(traceMethod, msg);
                break;
            }
            case DEBUG: {
                this.logMessage(debugMethod, msg);
                break;
            }
            case INFO: {
                this.logMessage(infoMethod, msg);
                break;
            }
            case WARNING: {
                this.logMessage(warningMethod, msg);
                break;
            }
            case ERROR: {
                this.logMessage(errorMethod, msg);
                break;
            }
            case FATAL: {
                this.logMessage(fatalMethod, msg);
                break;
            }
            default: {
                this.logMessage(infoMethod, msg);
            }
        }
    }

    public void log(Log.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.logMessage(traceThrowableMethod, msg, t);
                break;
            }
            case DEBUG: {
                this.logMessage(debugThrowableMethod, msg, t);
                break;
            }
            case INFO: {
                this.logMessage(infoThrowableMethod, msg, t);
                break;
            }
            case WARNING: {
                this.logMessage(warningThrowableMethod, msg, t);
                break;
            }
            case ERROR: {
                this.logMessage(errorThrowableMethod, msg, t);
                break;
            }
            case FATAL: {
                this.logMessage(fatalThrowableMethod, msg, t);
                break;
            }
            default: {
                this.logMessage(infoMethod, msg, t);
            }
        }
    }

    private static void findMethods() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        getLogMethod = CommonsLoggingLog.getMethod(clazz, "getLog", String.class);
        try {
            clazz = Class.forName("org.apache.commons.logging.Log");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        isTraceEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isTraceEnabled", new Class[0]);
        isDebugEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isDebugEnabled", new Class[0]);
        isInfoEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isInfoEnabled", new Class[0]);
        isWarnEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isWarnEnabled", new Class[0]);
        isErrorEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isErrorEnabled", new Class[0]);
        isFatalEnabledMethod = CommonsLoggingLog.getMethod(clazz, "isFatalEnabled", new Class[0]);
        traceMethod = CommonsLoggingLog.getMethod(clazz, "trace", Object.class);
        traceThrowableMethod = CommonsLoggingLog.getMethod(clazz, "trace", Object.class, Throwable.class);
        debugMethod = CommonsLoggingLog.getMethod(clazz, "debug", Object.class);
        debugThrowableMethod = CommonsLoggingLog.getMethod(clazz, "debug", Object.class, Throwable.class);
        infoMethod = CommonsLoggingLog.getMethod(clazz, "info", Object.class);
        infoThrowableMethod = CommonsLoggingLog.getMethod(clazz, "info", Object.class, Throwable.class);
        warningMethod = CommonsLoggingLog.getMethod(clazz, "warn", Object.class);
        warningThrowableMethod = CommonsLoggingLog.getMethod(clazz, "warn", Object.class, Throwable.class);
        errorMethod = CommonsLoggingLog.getMethod(clazz, "error", Object.class);
        errorThrowableMethod = CommonsLoggingLog.getMethod(clazz, "error", Object.class, Throwable.class);
        fatalMethod = CommonsLoggingLog.getMethod(clazz, "fatal", Object.class);
        fatalThrowableMethod = CommonsLoggingLog.getMethod(clazz, "fatal", Object.class, Throwable.class);
    }

    private boolean isLevelEnabled(Method method) {
        if (this.log != null) {
            try {
                return (Boolean)method.invoke(this.log, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void logMessage(Method method, String message) {
        if (this.log != null) {
            try {
                method.invoke(this.log, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logMessage(Method method, String message, Throwable t) {
        if (this.log != null) {
            try {
                method.invoke(this.log, message, t);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }
}

