/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.lunatech.doclets.jax.jaxb.model.Registry;
import com.lunatech.doclets.jax.writers.DocletWriter;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryWriter
extends DocletWriter {
    private Registry registry;

    public SummaryWriter(JAXConfiguration configuration, Registry registry) {
        super(configuration, SummaryWriter.getWriter(configuration));
        this.registry = registry;
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration) {
        try {
            return new HtmlDocletWriter(configuration.parentConfiguration, "", "overview-summary.html", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printHeader();
        this.printMenu("Overview");
        ArrayList<JAXBClass> classes = new ArrayList<JAXBClass>(this.registry.getJAXBClasses());
        Collections.sort(classes);
        this.printClasses(classes);
        this.tag("hr");
        this.printMenu("Overview");
        this.printFooter();
        this.writer.flush();
        this.writer.close();
    }

    private void printClasses(Collection<JAXBClass> classes) {
        this.tag("hr");
        this.open("table class='info'");
        this.around("caption class='TableCaption'", "Elements");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Name");
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        for (JAXBClass klass : classes) {
            this.open("tr");
            this.open("td");
            this.around("a href='" + this.writer.relativePath + Utils.classToPath(klass) + "/" + klass.getShortClassName() + ".html'", klass.getName());
            this.close("td");
            this.open("td");
            Doc javaDoc = klass.getJavaDoc();
            if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
                this.writer.printSummaryComment(javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    protected void printHeader() {
        this.printHeader("Overview of XML elements");
    }
}

