/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.exception.OException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OOneEntryPerKeyLockManager<T>
implements OLockManager<T> {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private long acquireTimeout;
    protected final ConcurrentLinkedHashMap<T, CountableLock> map;
    private final boolean enabled;
    private final int amountOfCachedInstances;
    private static final Object NULL_KEY = new Object();

    public OOneEntryPerKeyLockManager(boolean iEnabled, int iAcquireTimeout, int amountOfCachedInstances) {
        this(iEnabled, iAcquireTimeout, OOneEntryPerKeyLockManager.defaultConcurrency(), amountOfCachedInstances);
    }

    public OOneEntryPerKeyLockManager(boolean iEnabled, int iAcquireTimeout, int concurrencyLevel, int amountOfCachedInstances) {
        this.amountOfCachedInstances = amountOfCachedInstances;
        int cL = OOneEntryPerKeyLockManager.closestInteger(concurrencyLevel);
        this.map = new ConcurrentLinkedHashMap.Builder().concurrencyLevel(cL).maximumWeightedCapacity(Long.MAX_VALUE).build();
        this.acquireTimeout = iAcquireTimeout;
        this.enabled = iEnabled;
    }

    @Override
    public Lock acquireSharedLock(T key) {
        this.acquireLock(key, LOCK.SHARED);
        return null;
    }

    @Override
    public void releaseSharedLock(T key) {
        this.releaseLock(Thread.currentThread(), key, LOCK.SHARED);
    }

    @Override
    public Lock acquireExclusiveLock(T key) {
        this.acquireLock(key, LOCK.EXCLUSIVE);
        return null;
    }

    @Override
    public void releaseExclusiveLock(T key) {
        this.releaseLock(Thread.currentThread(), key, LOCK.EXCLUSIVE);
    }

    public void acquireLock(T iResourceId, LOCK iLockType) {
        this.acquireLock(iResourceId, iLockType, this.acquireTimeout);
    }

    public void acquireLock(T iResourceId, LOCK iLockType, long iTimeout) {
        block20: {
            int counter;
            Object keyToRemove;
            CountableLock lockToRemove;
            Iterator keyToRemoveIterator;
            CountableLock lock;
            if (!this.enabled) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            Object immutableResource = this.getImmutableResourceId(iResourceId);
            if (immutableResource == null) {
                immutableResource = NULL_KEY;
            }
            do {
                if ((lock = (CountableLock)this.map.get(immutableResource)) == null) continue;
                int oldLockCount = lock.countLocks.get();
                if (oldLockCount >= 0) {
                    if (!lock.countLocks.compareAndSet(oldLockCount, oldLockCount + 1)) continue;
                    break;
                }
                this.map.remove(immutableResource, (Object)lock);
            } while (lock != null);
            if (lock == null) {
                CountableLock oldLock;
                while ((oldLock = (CountableLock)this.map.putIfAbsent(immutableResource, (Object)(lock = new CountableLock()))) != null) {
                    lock = oldLock;
                    int oldValue = lock.countLocks.get();
                    if (oldValue >= 0) {
                        if (!lock.countLocks.compareAndSet(oldValue, oldValue + 1)) continue;
                        assert (this.map.get(immutableResource) == lock);
                        break;
                    }
                    this.map.remove(immutableResource, (Object)lock);
                }
            }
            if (this.map.size() > this.amountOfCachedInstances && (keyToRemoveIterator = this.map.ascendingKeySetWithLimit(1).iterator()).hasNext() && (lockToRemove = (CountableLock)this.map.get(keyToRemove = keyToRemoveIterator.next())) != null && (counter = lockToRemove.countLocks.get()) == 0 && lockToRemove.countLocks.compareAndSet(counter, -1)) {
                assert (lockToRemove.countLocks.get() == -1);
                this.map.remove(keyToRemove, (Object)lockToRemove);
            }
            try {
                if (iTimeout <= 0L) {
                    if (iLockType == LOCK.SHARED) {
                        lock.readWriteLock.readLock().lock();
                    } else {
                        lock.readWriteLock.writeLock().lock();
                    }
                    break block20;
                }
                try {
                    if (iLockType == LOCK.SHARED ? !lock.readWriteLock.readLock().tryLock(iTimeout, TimeUnit.MILLISECONDS) : !lock.readWriteLock.writeLock().tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                        throw new OLockException("Timeout (" + iTimeout + "ms) on acquiring resource '" + iResourceId + "' because is locked from another thread");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw OException.wrapException(new OLockException("Thread interrupted while waiting for resource '" + iResourceId + "'"), e);
                }
            }
            catch (RuntimeException e) {
                int usages = lock.countLocks.decrementAndGet();
                if (usages == 0) {
                    this.map.remove(immutableResource);
                }
                throw e;
            }
        }
    }

    public void releaseLock(Object iRequester, T iResourceId, LOCK iLockType) throws OLockException {
        CountableLock lock;
        if (!this.enabled) {
            return;
        }
        if (iResourceId == null) {
            iResourceId = NULL_KEY;
        }
        if ((lock = (CountableLock)this.map.get(iResourceId)) == null) {
            throw new OLockException("Error on releasing a non acquired lock by the requester '" + iRequester + "' against the resource: '" + iResourceId + "'");
        }
        lock.countLocks.decrementAndGet();
        if (iLockType == LOCK.SHARED) {
            lock.readWriteLock.readLock().unlock();
        } else {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Lock[] acquireExclusiveLocksInBatch(T ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        T[] sortedValues = OPartitionedLockManager.getOrderedValues(values);
        for (int n = 0; n < sortedValues.length; ++n) {
            this.acquireLock(sortedValues[n], LOCK.EXCLUSIVE);
        }
        return null;
    }

    @Override
    public void acquireExclusiveLocksInBatch(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Collection<T> valCopy = OPartitionedLockManager.getOrderedValues(values);
        for (T val : valCopy) {
            this.acquireExclusiveLock(val);
        }
    }

    @Override
    public void lockAllExclusive() {
        for (CountableLock lock : this.map.values()) {
            lock.readWriteLock.writeLock().lock();
        }
    }

    @Override
    public void unlockAllExclusive() {
        for (CountableLock lock : this.map.values()) {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    public int getCountCurrentLocks() {
        return this.map.size();
    }

    protected T getImmutableResourceId(T iResourceId) {
        return iResourceId;
    }

    private static int defaultConcurrency() {
        return Runtime.getRuntime().availableProcessors() << 6 > 16 ? Runtime.getRuntime().availableProcessors() << 6 : 16;
    }

    private static int closestInteger(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static class CountableLock {
        private final AtomicInteger countLocks = new AtomicInteger(1);
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        private CountableLock() {
        }
    }

    public static enum LOCK {
        SHARED,
        EXCLUSIVE;

    }
}

