/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.types.OModifiableInteger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OReadersWriterSpinLock
extends AbstractOwnableSynchronizer {
    private static final long serialVersionUID = 7975120282194559960L;
    private final transient ODistributedCounter distributedCounter = new ODistributedCounter();
    private final transient AtomicReference<WNode> tail = new AtomicReference();
    private final transient ThreadLocal<OModifiableInteger> lockHolds = new InitOModifiableInteger();
    private final transient ThreadLocal<WNode> myNode = new InitWNode();
    private final transient ThreadLocal<WNode> predNode = new ThreadLocal();

    public OReadersWriterSpinLock() {
        WNode wNode = new WNode();
        wNode.locked = false;
        this.tail.set(wNode);
    }

    public void acquireReadLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        int holds = lHolds.intValue();
        if (holds > 0) {
            lHolds.increment();
            return;
        }
        if (holds < 0) {
            return;
        }
        this.distributedCounter.increment();
        WNode wNode = this.tail.get();
        while (wNode.locked) {
            this.distributedCounter.decrement();
            while (wNode.locked && wNode == this.tail.get()) {
                wNode.waitingReaders.add(Thread.currentThread());
                if (wNode.locked && wNode == this.tail.get()) {
                    LockSupport.park(this);
                }
                wNode = this.tail.get();
            }
            this.distributedCounter.increment();
            wNode = this.tail.get();
        }
        lHolds.increment();
        assert (lHolds.intValue() == 1);
    }

    public void releaseReadLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        int holds = lHolds.intValue();
        if (holds > 1) {
            this.lockHolds.get().decrement();
            return;
        }
        if (holds < 0) {
            return;
        }
        this.distributedCounter.decrement();
        lHolds.decrement();
        assert (lHolds.intValue() == 0);
    }

    public void acquireWriteLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        if (lHolds.intValue() < 0) {
            lHolds.decrement();
            return;
        }
        WNode node = this.myNode.get();
        node.locked = true;
        WNode pNode = this.tail.getAndSet(this.myNode.get());
        this.predNode.set(pNode);
        while (pNode.locked) {
            pNode.waitingWriter = Thread.currentThread();
            if (!pNode.locked) continue;
            LockSupport.park(this);
        }
        pNode.waitingWriter = null;
        while (!this.distributedCounter.isEmpty()) {
        }
        this.setExclusiveOwnerThread(Thread.currentThread());
        lHolds.decrement();
        assert (lHolds.intValue() == -1);
    }

    public void releaseWriteLock() {
        Thread waitingReader;
        OModifiableInteger lHolds = this.lockHolds.get();
        if (lHolds.intValue() < -1) {
            lHolds.increment();
            return;
        }
        this.setExclusiveOwnerThread(null);
        WNode node = this.myNode.get();
        node.locked = false;
        Thread waitingWriter = node.waitingWriter;
        if (waitingWriter != null) {
            LockSupport.unpark(waitingWriter);
        }
        while ((waitingReader = (Thread)node.waitingReaders.poll()) != null) {
            LockSupport.unpark(waitingReader);
        }
        this.myNode.set(this.predNode.get());
        this.predNode.set(null);
        lHolds.increment();
        assert (lHolds.intValue() == 0);
    }

    private static final class WNode {
        private final Queue<Thread> waitingReaders = new ConcurrentLinkedQueue<Thread>();
        private volatile boolean locked = true;
        private volatile Thread waitingWriter;

        private WNode() {
        }
    }

    private static final class InitOModifiableInteger
    extends ThreadLocal<OModifiableInteger> {
        private InitOModifiableInteger() {
        }

        @Override
        protected OModifiableInteger initialValue() {
            return new OModifiableInteger();
        }
    }

    private static final class InitWNode
    extends ThreadLocal<WNode> {
        private InitWNode() {
        }

        @Override
        protected WNode initialValue() {
            return new WNode();
        }
    }
}

