/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.directmemory.OByteBufferPoolMXBean;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OByteBufferPool
implements OByteBufferPoolMXBean {
    public static final String MBEAN_NAME = "com.orientechnologies.common.directmemory:type=OByteBufferPoolMXBean";
    private static final OByteBufferPool INSTANCE;
    private final int pageSize;
    private final ByteBuffer zeroPage;
    private final AtomicReference<BufferHolder> lastPreallocatedArea;
    private final AtomicLong nextAllocationPosition = new AtomicLong();
    private final int maxPagesPerSingleArea;
    private final ConcurrentLinkedQueue<ByteBuffer> pool = new ConcurrentLinkedQueue();
    private final AtomicLong overflowBufferCount = new AtomicLong();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();

    public static OByteBufferPool instance() {
        return INSTANCE;
    }

    public OByteBufferPool(int pageSize) {
        this(pageSize, -1);
    }

    public OByteBufferPool(int pageSize, int maxChunkSize) {
        this.pageSize = pageSize;
        this.zeroPage = ByteBuffer.allocateDirect(pageSize).order(ByteOrder.nativeOrder());
        int pagesPerArea = maxChunkSize / pageSize;
        if (pagesPerArea > 1) {
            pagesPerArea = this.closestPowerOfTwo(pagesPerArea);
            while ((long)pagesPerArea * (long)pageSize > (long)maxChunkSize) {
                pagesPerArea >>>= 1;
            }
            this.maxPagesPerSingleArea = pagesPerArea;
            this.lastPreallocatedArea = new AtomicReference();
        } else {
            this.maxPagesPerSingleArea = 1;
            this.lastPreallocatedArea = null;
        }
    }

    public int getSize() {
        return this.pool.size();
    }

    public int getMaxPagesPerChunk() {
        return this.maxPagesPerSingleArea;
    }

    private int closestPowerOfTwo(int value) {
        int n = value - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer acquireDirect(boolean clear) {
        ByteBuffer buffer = this.pool.poll();
        if (buffer != null) {
            if (clear) {
                buffer.position(0);
                buffer.put(this.zeroPage.duplicate());
            }
            buffer.position(0);
            return buffer;
        }
        if (this.maxPagesPerSingleArea > 1) {
            long currentAllocationPosition = this.nextAllocationPosition.getAndIncrement();
            int position = (int)(currentAllocationPosition & (long)(this.maxPagesPerSingleArea - 1));
            int bufferIndex = (int)(currentAllocationPosition / (long)this.maxPagesPerSingleArea);
            BufferHolder bfh = null;
            try {
                block19: {
                    while (true) {
                        BufferHolder nbfh;
                        bfh = this.lastPreallocatedArea.get();
                        assert (bfh == null || bfh.index <= bufferIndex);
                        if (bfh == null) {
                            bfh = new BufferHolder(bufferIndex);
                            if (!this.lastPreallocatedArea.compareAndSet(null, bfh)) continue;
                            this.allocateBuffer(bfh);
                        } else if (bfh.buffer == null) {
                            try {
                                bfh.latch.await();
                            }
                            catch (InterruptedException e) {
                                throw OException.wrapException(new OInterruptedException("Wait of new preallocated memory area was interrupted"), e);
                            }
                        }
                        if (bfh.index >= bufferIndex) break block19;
                        int requestedPages = bfh.requested.get();
                        if (requestedPages < this.maxPagesPerSingleArea) {
                            try {
                                bfh.filled.await();
                            }
                            catch (InterruptedException e) {
                                throw OException.wrapException(new OInterruptedException("Wait of new preallocated memory area was interrupted"), e);
                            }
                        }
                        if (this.lastPreallocatedArea.compareAndSet(bfh, nbfh = new BufferHolder(bufferIndex))) {
                            bfh = nbfh;
                            this.allocateBuffer(bfh);
                            break block19;
                        }
                        if (!$assertionsDisabled && nbfh.index != bufferIndex) break;
                    }
                    throw new AssertionError();
                }
                int rawPosition = position * this.pageSize;
                ByteBuffer db = bfh.buffer.duplicate();
                db.position(rawPosition);
                db.limit(rawPosition + this.pageSize);
                ByteBuffer slice = db.slice();
                slice.order(ByteOrder.nativeOrder());
                if (clear) {
                    slice.position(0);
                    slice.put(this.zeroPage.duplicate());
                }
                slice.position(0);
                ByteBuffer byteBuffer = slice;
                return byteBuffer;
            }
            finally {
                int completedRequests;
                if (bfh != null && (completedRequests = bfh.requested.incrementAndGet()) == this.maxPagesPerSingleArea) {
                    bfh.filled.countDown();
                }
            }
        }
        this.overflowBufferCount.incrementAndGet();
        return ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder());
    }

    private void allocateBuffer(BufferHolder bfh) {
        int allocationSize = this.maxPagesPerSingleArea * this.pageSize;
        try {
            bfh.buffer = ByteBuffer.allocateDirect(allocationSize).order(ByteOrder.nativeOrder());
        }
        finally {
            bfh.latch.countDown();
        }
    }

    public void release(ByteBuffer buffer) {
        this.pool.offer(buffer);
    }

    @Override
    public int getBufferSize() {
        return this.pageSize;
    }

    @Override
    public long getAllocatedBufferCount() {
        return this.nextAllocationPosition.get();
    }

    @Override
    public long getOverflowBufferCount() {
        return this.overflowBufferCount.get();
    }

    @Override
    public int getBuffersInThePool() {
        return this.getSize();
    }

    @Override
    public long getAllocatedMemory() {
        long memory = this.getOverflowBufferCount();
        long allocatedAreas = (this.getAllocatedBufferCount() + (long)this.maxPagesPerSingleArea - 1L) / (long)this.maxPagesPerSingleArea;
        return (memory += allocatedAreas * (long)this.maxPagesPerSingleArea) * (long)this.pageSize;
    }

    @Override
    public long getAllocatedMemoryInMB() {
        return this.getAllocatedMemory() / 0x100000L;
    }

    @Override
    public double getAllocatedMemoryInGB() {
        return Math.ceil((double)(this.getAllocatedMemory() * 100L) / 1.073741824E9) / 100.0;
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(this, mbeanName);
                } else {
                    this.mbeanIsRegistered.set(false);
                    OLogManager.instance().warn((Object)this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
                }
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (NotCompliantMBeanException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
        }
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (InstanceNotFoundException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
        }
    }

    static {
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        int memoryChunkSize = OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsInteger();
        INSTANCE = new OByteBufferPool(pageSize, memoryChunkSize);
    }

    private static final class BufferHolder {
        private volatile ByteBuffer buffer;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CountDownLatch filled = new CountDownLatch(1);
        private final AtomicInteger requested = new AtomicInteger();
        private final int index;

        public BufferHolder(int index) {
            this.index = index;
        }
    }
}

