/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.log.OAnsiLogFormatter;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OLogManager {
    private static final String DEFAULT_LOG = "com.orientechnologies";
    private static final String ENV_INSTALL_CUSTOM_FORMATTER = "orientdb.installCustomFormatter";
    private static final OLogManager instance = new OLogManager();
    private boolean debug = false;
    private boolean info = true;
    private boolean warn = true;
    private boolean error = true;
    private Level minimumLevel = Level.SEVERE;
    private final ConcurrentMap<String, Logger> loggersCache = new ConcurrentHashMap<String, Logger>();

    protected OLogManager() {
    }

    public static OLogManager instance() {
        return instance;
    }

    public void installCustomFormatter() {
        boolean installCustomFormatter = Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables("${orientdb.installCustomFormatter}", "true"));
        if (!installCustomFormatter) {
            return;
        }
        try {
            Logger log = Logger.getLogger("");
            this.setLevelInternal(log.getLevel());
            if (log.getHandlers().length == 0) {
                ConsoleHandler h = new ConsoleHandler();
                h.setFormatter(new OAnsiLogFormatter());
                log.addHandler(h);
            } else {
                for (Handler h : log.getHandlers()) {
                    if (!(h instanceof ConsoleHandler) || h.getFormatter().getClass().equals(OAnsiLogFormatter.class)) continue;
                    h.setFormatter(new OAnsiLogFormatter());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error while installing custom formatter. Logging could be disabled. Cause: " + e.toString());
        }
    }

    public void setConsoleLevel(String iLevel) {
        this.setLevel(iLevel, ConsoleHandler.class);
    }

    public void setFileLevel(String iLevel) {
        this.setLevel(iLevel, FileHandler.class);
    }

    public void log(Object iRequester, Level iLevel, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (iMessage != null) {
            Logger oldLogger;
            try {
                String dbName;
                ODatabaseDocumentInternal db;
                ODatabaseDocumentInternal oDatabaseDocumentInternal = db = ODatabaseRecordThreadLocal.INSTANCE != null ? ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() : null;
                if (db != null && db.getStorage() != null && db.getStorage() instanceof OAbstractPaginatedStorage && (dbName = db.getStorage().getName()) != null) {
                    iMessage = "$ANSI{green {db=" + dbName + "}} " + iMessage;
                }
            }
            catch (Throwable db) {
                // empty catch block
            }
            String requesterName = iRequester != null ? iRequester.getClass().getName() : DEFAULT_LOG;
            Logger log = (Logger)this.loggersCache.get(requesterName);
            if (log == null && (log = Logger.getLogger(requesterName)) != null && (oldLogger = this.loggersCache.putIfAbsent(requesterName, log)) != null) {
                log = oldLogger;
            }
            if (log == null) {
                try {
                    System.err.println(String.format(iMessage, iAdditionalArgs));
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on formatting message", e, new Object[0]);
                }
            } else if (log.isLoggable(iLevel)) {
                try {
                    String msg = String.format(iMessage, iAdditionalArgs);
                    if (iException != null) {
                        log.log(iLevel, msg, iException);
                    } else {
                        log.log(iLevel, msg);
                    }
                }
                catch (Exception e) {
                    System.err.print(String.format("Error on formatting message '%s'. Exception: %s", iMessage, e.toString()));
                }
            }
        }
    }

    public void debug(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, null, iAdditionalArgs);
        }
    }

    public void debug(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, iException, iAdditionalArgs);
        }
    }

    public void info(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            this.log(iRequester, Level.INFO, iMessage, null, iAdditionalArgs);
        }
    }

    public void info(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            this.log(iRequester, Level.INFO, iMessage, iException, iAdditionalArgs);
        }
    }

    public void warn(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            this.log(iRequester, Level.WARNING, iMessage, null, iAdditionalArgs);
        }
    }

    public void warn(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            this.log(iRequester, Level.WARNING, iMessage, iException, iAdditionalArgs);
        }
    }

    public void config(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        this.log(iRequester, Level.CONFIG, iMessage, null, iAdditionalArgs);
    }

    public void error(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        this.log(iRequester, Level.SEVERE, iMessage, null, iAdditionalArgs);
    }

    public void error(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isErrorEnabled()) {
            this.log(iRequester, Level.SEVERE, iMessage, iException, iAdditionalArgs);
        }
    }

    public boolean isWarn() {
        return this.warn;
    }

    public boolean isLevelEnabled(Level level) {
        if (level.equals(Level.FINER) || level.equals(Level.FINE) || level.equals(Level.FINEST)) {
            return this.debug;
        }
        if (level.equals(Level.INFO)) {
            return this.info;
        }
        if (level.equals(Level.WARNING)) {
            return this.warn;
        }
        if (level.equals(Level.SEVERE)) {
            return this.error;
        }
        return false;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void setDebugEnabled(boolean debug) {
        this.debug = debug;
    }

    public boolean isInfoEnabled() {
        return this.info;
    }

    public void setInfoEnabled(boolean info) {
        this.info = info;
    }

    public boolean isWarnEnabled() {
        return this.warn;
    }

    public void setWarnEnabled(boolean warn) {
        this.warn = warn;
    }

    public boolean isErrorEnabled() {
        return this.error;
    }

    public void setErrorEnabled(boolean error) {
        this.error = error;
    }

    public Level setLevel(String iLevel, Class<? extends Handler> iHandler) {
        Level level;
        Level level2 = level = iLevel != null ? Level.parse(iLevel.toUpperCase(Locale.ENGLISH)) : Level.INFO;
        if (level.intValue() < this.minimumLevel.intValue()) {
            this.minimumLevel = level;
            this.setLevelInternal(level);
        }
        block0: for (Logger log = Logger.getLogger(DEFAULT_LOG); log != null; log = log.getParent()) {
            for (Handler h : log.getHandlers()) {
                if (!h.getClass().isAssignableFrom(iHandler)) continue;
                h.setLevel(level);
                continue block0;
            }
        }
        return level;
    }

    protected void setLevelInternal(Level level) {
        if (level == null) {
            return;
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINE) || level.equals(Level.FINEST)) {
            this.error = true;
            this.warn = true;
            this.info = true;
            this.debug = true;
        } else if (level.equals(Level.INFO)) {
            this.error = true;
            this.warn = true;
            this.info = true;
            this.debug = false;
        } else if (level.equals(Level.WARNING)) {
            this.error = true;
            this.warn = true;
            this.info = false;
            this.debug = false;
        } else if (level.equals(Level.SEVERE)) {
            this.error = true;
            this.warn = false;
            this.info = false;
            this.debug = false;
        }
    }

    public void flush() {
        for (Handler h : Logger.getLogger("global").getHandlers()) {
            h.flush();
        }
    }

    public OCommandOutputListener getCommandOutputListener(final Object iThis, final Level iLevel) {
        return new OCommandOutputListener(){

            @Override
            public void onMessage(String iText) {
                OLogManager.this.log(iThis, iLevel, iText, null, new Object[0]);
            }
        };
    }
}

