/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.hook.ORecordHookAbstract;
import com.orientechnologies.orient.core.record.ORecord;

public class OCommandCacheHook
extends ORecordHookAbstract {
    private final OCommandCache cmdCache;
    private final ODatabaseDocumentTx database;

    public OCommandCacheHook(ODatabaseDocumentTx iDatabase) {
        this.database = iDatabase;
        this.cmdCache = iDatabase.getMetadata().getCommandCache().isEnabled() ? iDatabase.getMetadata().getCommandCache() : null;
    }

    @Override
    public void onRecordAfterCreate(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    @Override
    public void onRecordAfterUpdate(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    @Override
    public void onRecordAfterDelete(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    protected void invalidateCache(ORecord iRecord) {
        if (this.cmdCache.getEvictStrategy() == OCommandCache.STRATEGY.PER_CLUSTER) {
            this.cmdCache.invalidateResultsOfCluster(this.database.getClusterNameById(iRecord.getIdentity().getClusterId()));
        } else {
            this.cmdCache.invalidateResultsOfCluster(null);
        }
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }
}

