/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.cache.OSoftRefsHashMap;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OCommandCacheSoftRefs
implements OCommandCache {
    private String CONFIG_FILE = "command-cache.json";
    ODocument configuration;
    private final String databaseName;
    private Set<String> clusters = new HashSet<String>();
    private volatile boolean enable = OGlobalConfiguration.COMMAND_CACHE_ENABLED.getValueAsBoolean();
    private OCommandCacheImplRefs cache = new OCommandCacheImplRefs();
    private int minExecutionTime = OGlobalConfiguration.COMMAND_CACHE_MIN_EXECUTION_TIME.getValueAsInteger();
    private int maxResultsetSize = OGlobalConfiguration.COMMAND_CACHE_MAX_RESULSET_SIZE.getValueAsInteger();
    private OCommandCache.STRATEGY evictStrategy = OCommandCache.STRATEGY.valueOf(OGlobalConfiguration.COMMAND_CACHE_EVICT_STRATEGY.getValueAsString());

    public OCommandCacheSoftRefs(String iDatabaseName) {
        this.databaseName = iDatabaseName;
        this.initCache();
    }

    private void initCache() {
        this.configuration = new ODocument();
        this.configuration.field("enabled", this.enable);
        this.configuration.field("evictStrategy", this.evictStrategy.toString());
        this.configuration.field("minExecutionTime", this.minExecutionTime);
        this.configuration.field("maxResultsetSize", this.maxResultsetSize);
        try {
            ODocument diskConfig = this.loadConfiguration();
            if (diskConfig != null) {
                this.configuration = diskConfig;
                this.configure();
            } else {
                this.updateCfgOnDisk();
            }
        }
        catch (Exception e) {
            OException.wrapException(new OConfigurationException("Cannot change Command Cache Cache configuration file '" + this.CONFIG_FILE + "'. Command Cache will use default settings"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConfig(ODocument cfg) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument oldConfig = this.configuration;
            this.configuration = cfg;
            this.configure();
            try {
                this.updateCfgOnDisk();
            }
            catch (IOException e) {
                OException.wrapException(new OConfigurationException("Cannot change Command Cache Cache configuration file '" + this.CONFIG_FILE + "'. Command Cache will use default settings"), e);
                this.configuration = oldConfig;
                this.configure();
            }
        }
    }

    protected void configure() {
        this.enable = (Boolean)this.configuration.field("enabled");
        String evict = (String)this.configuration.field("evictStrategy");
        this.evictStrategy = OCommandCache.STRATEGY.valueOf(evict);
        this.minExecutionTime = (Integer)this.configuration.field("minExecutionTime");
        this.maxResultsetSize = (Integer)this.configuration.field("maxResultsetSize");
    }

    private boolean updateCfgOnDisk() throws IOException {
        File f = this.getConfigFile();
        if (f != null) {
            OLogManager.instance().info((Object)this, "Saving Command Cache config for db: %s", this.databaseName);
            OIOUtils.writeFile(f, this.configuration.toJSON("prettyPrint"));
            return true;
        }
        return false;
    }

    private ODocument loadConfiguration() {
        try {
            File f = this.getConfigFile();
            if (f != null && f.exists()) {
                String configurationContent = OIOUtils.readFileAsString(f);
                return new ODocument().fromJSON(configurationContent);
            }
        }
        catch (Exception e) {
            OException.wrapException(new OConfigurationException("Cannot load Command Cache Cache configuration file '" + this.CONFIG_FILE + "'. Command Cache will use default settings"), e);
        }
        return null;
    }

    private File getConfigFile() {
        OStorage storage = Orient.instance().getStorage(this.databaseName);
        if (storage instanceof OLocalPaginatedStorage) {
            return new File(((OLocalPaginatedStorage)storage).getStoragePath() + File.separator + this.CONFIG_FILE);
        }
        return null;
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
        this.clear();
        this.deleteFileIfExists();
    }

    protected void deleteFileIfExists() {
        File f = this.getConfigFile();
        if (f != null) {
            OLogManager.instance().info((Object)this, "Removing Command Cache config for db: %s", this.databaseName);
            f.delete();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    @Override
    public OCommandCacheSoftRefs enable() {
        this.enable = true;
        this.configuration.field("enabled", true);
        try {
            this.updateCfgOnDisk();
        }
        catch (IOException e) {
            OException.wrapException(new OConfigurationException("Cannot write Command Cache Cache configuration to file '" + this.CONFIG_FILE + "'"), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandCacheSoftRefs disable() {
        this.enable = false;
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            this.clusters.clear();
            this.cache.clear();
        }
        this.configuration.field("enabled", true);
        try {
            this.updateCfgOnDisk();
        }
        catch (IOException e) {
            OException.wrapException(new OConfigurationException("Cannot write Command Cache Cache configuration to file '" + this.CONFIG_FILE + "'"), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(OSecurityUser iUser, String queryText, int iLimit) {
        OCachedResult result;
        if (!this.enable) {
            return null;
        }
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            String key = this.getKey(iUser, queryText, iLimit);
            result = (OCachedResult)this.cache.get(key);
            if (result != null) {
                int resultsetSize = 1;
                if (result.result instanceof ORecord) {
                    ((ORecord)result.result).toStream();
                } else if (OMultiValue.isMultiValue(result.result)) {
                    resultsetSize = OMultiValue.getSize(result.result);
                    for (Object rc : OMultiValue.getMultiValueIterable(result.result)) {
                        if (rc == null || !(rc instanceof ORecord)) continue;
                        ((ORecord)rc).toStream();
                    }
                }
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Reused cached resultset size=%d", resultsetSize);
                }
            }
        }
        OProfiler profiler = Orient.instance().getProfiler();
        if (profiler.isRecording()) {
            if (result != null) {
                profiler.updateCounter(profiler.getDatabaseMetric(this.databaseName, "queryCache.hit"), "Results returned by Query Cache", 1L);
            } else {
                profiler.updateCounter(profiler.getDatabaseMetric(this.databaseName, "queryCache.miss"), "Results not returned by Query Cache", 1L);
            }
        }
        return result != null ? result.result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(OSecurityUser iUser, String queryText, Object iResult, int iLimit, Set<String> iInvolvedClusters, long iExecutionTime) {
        if (queryText == null || iResult == null) {
            return;
        }
        if (!this.enable) {
            return;
        }
        if (iExecutionTime < (long)this.minExecutionTime) {
            return;
        }
        int resultsetSize = 1;
        if (iResult instanceof OResultSet && (resultsetSize = ((OResultSet)iResult).size()) > this.maxResultsetSize) {
            return;
        }
        if (this.evictStrategy != OCommandCache.STRATEGY.PER_CLUSTER) {
            iInvolvedClusters = null;
        }
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            String key = this.getKey(iUser, queryText, iLimit);
            OCachedResult value = new OCachedResult(iResult, iInvolvedClusters);
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Storing resultset in cache size=%d", resultsetSize);
            }
            this.cache.put(key, value);
            if (iInvolvedClusters != null) {
                this.clusters.addAll(iInvolvedClusters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(OSecurityUser iUser, String queryText, int iLimit) {
        if (!this.enable) {
            return;
        }
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            String key = this.getKey(iUser, queryText, iLimit);
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandCacheSoftRefs clear() {
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            this.cache = new OCommandCacheImplRefs();
            this.clusters.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateResultsOfCluster(String iCluster) {
        if (!this.enable) {
            return;
        }
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            if (this.cache.size() == 0) {
                return;
            }
            if (this.evictStrategy == OCommandCache.STRATEGY.INVALIDATE_ALL) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Invalidate all cached results (%d)", this.size());
                }
                this.clear();
                return;
            }
            if (!this.clusters.remove(iCluster)) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "No results found for '%s'", iCluster);
                }
                return;
            }
            int evicted = 0;
            Iterator it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                OCachedResult cached = (OCachedResult)it.next().getValue();
                if (cached == null || cached.involvedClusters != null && !cached.involvedClusters.isEmpty() && !cached.involvedClusters.contains(iCluster)) continue;
                cached.clear();
                it.remove();
            }
            if (evicted > 0 && OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Invalidate %d cached results associated to the cluster '%s'", evicted, iCluster);
            }
        }
    }

    public int getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public OCommandCacheSoftRefs setMinExecutionTime(int minExecutionTime) {
        this.minExecutionTime = minExecutionTime;
        return this;
    }

    @Override
    public int getMaxResultsetSize() {
        return this.maxResultsetSize;
    }

    public OCommandCacheSoftRefs setMaxResultsetSize(int maxResultsetSize) {
        this.maxResultsetSize = maxResultsetSize;
        return this;
    }

    @Override
    public OCommandCache.STRATEGY getEvictStrategy() {
        return this.evictStrategy;
    }

    public OCommandCacheSoftRefs setEvictStrategy(OCommandCache.STRATEGY evictStrategy) {
        this.evictStrategy = evictStrategy;
        return this;
    }

    protected String getKey(OSecurityUser iUser, String queryText, int iLimit) {
        if (iUser == null) {
            return "<nouser>." + queryText + "." + iLimit;
        }
        return iUser + "." + queryText + "." + iLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, OCachedResult>> entrySet() {
        OCommandCacheSoftRefs oCommandCacheSoftRefs = this;
        synchronized (oCommandCacheSoftRefs) {
            return this.cache.entrySet();
        }
    }

    private class OCommandCacheImplRefs
    extends OSoftRefsHashMap<String, OCachedResult> {
        private OCommandCacheImplRefs() {
        }
    }

    public static class OCachedResult {
        Object result;
        Set<String> involvedClusters;

        public OCachedResult(Object result, Set<String> involvedClusters) {
            this.involvedClusters = involvedClusters;
            this.result = result;
        }

        protected void clear() {
            this.result = null;
            this.involvedClusters = null;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

