/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.conflict;

import com.orientechnologies.orient.core.conflict.OVersionRecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class OContentRecordConflictStrategy
extends OVersionRecordConflictStrategy {
    public static final String NAME = "content";

    @Override
    public byte[] onUpdate(OStorage storage, byte iRecordType, ORecordId rid, int iRecordVersion, byte[] iRecordContent, AtomicInteger iDatabaseVersion) {
        boolean hasSameContent;
        if (iRecordType == 100) {
            OStorageOperationResult<ORawBuffer> res = storage.readRecord(rid, null, false, null);
            ODocument storedRecord = new ODocument(rid).fromStream(res.getResult().getBuffer());
            ODocument newRecord = new ODocument().fromStream(iRecordContent);
            ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.INSTANCE.get();
            hasSameContent = ODocumentHelper.hasSameContentOf(storedRecord, currentDb, newRecord, currentDb, null, false);
        } else {
            ORecordAbstract storedRecord = (ORecordAbstract)rid.getRecord();
            hasSameContent = Arrays.equals(storedRecord.toStream(), iRecordContent);
        }
        if (hasSameContent) {
            iDatabaseVersion.set(Math.max(iDatabaseVersion.get(), iRecordVersion));
        } else {
            this.checkVersions(rid, iRecordVersion, iDatabaseVersion.get());
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

