/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODocumentFieldVisitor;
import com.orientechnologies.orient.core.db.document.ODocumentFieldWalker;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class ORidBagDeleteHook
extends ODocumentHookAbstract {
    public ORidBagDeleteHook(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument document) {
        this.deleteAllRidBags(document);
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    private void deleteAllRidBags(ODocument document) {
        int version = document.getVersion();
        if (document.fields() == 0 && document.getIdentity().isPersistent()) {
            document.reload();
            if (version > -1 && document.getVersion() != version) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(document.getIdentity(), document.getVersion(), version, 2);
            }
        }
        ODocumentFieldWalker documentFieldWalker = new ODocumentFieldWalker();
        RidBagDeleter ridBagDeleter = new RidBagDeleter();
        documentFieldWalker.walkDocument(document, ridBagDeleter);
    }

    private static final class RidBagDeleter
    implements ODocumentFieldVisitor {
        private RidBagDeleter() {
        }

        @Override
        public Object visitField(OType type, OType linkedType, Object value) {
            if (value instanceof ORidBag) {
                ((ORidBag)value).delete();
            }
            return value;
        }

        @Override
        public boolean goFurther(OType type, OType linkedType, Object value, Object newValue) {
            return true;
        }

        @Override
        public boolean goDeeper(OType type, OType linkedType, Object value) {
            return true;
        }

        @Override
        public boolean updateMode() {
            return false;
        }
    }
}

