/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerShared
extends OSBTreeCollectionManagerAbstract
implements OOrientStartupListener,
OOrientShutdownListener {
    private final OAbstractPaginatedStorage storage;
    private volatile ThreadLocal<Map<UUID, OBonsaiCollectionPointer>> collectionPointerChanges = new CollectionPointerChangesThreadLocal();

    public OSBTreeCollectionManagerShared(OAbstractPaginatedStorage storage) {
        this.storage = storage;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public OSBTreeCollectionManagerShared(int evictionThreshold, int cacheMaxSize, OAbstractPaginatedStorage storage) {
        super(evictionThreshold, cacheMaxSize);
        this.storage = storage;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public void onShutdown() {
        this.collectionPointerChanges = null;
    }

    @Override
    public void onStartup() {
        if (this.collectionPointerChanges == null) {
            this.collectionPointerChanges = new CollectionPointerChangesThreadLocal();
        }
    }

    @Override
    public OBonsaiCollectionPointer createSBTree(int clusterId, UUID ownerUUID) {
        OBonsaiCollectionPointer pointer = super.createSBTree(clusterId, ownerUUID);
        if (ownerUUID != null) {
            Map<UUID, OBonsaiCollectionPointer> changedPointers = this.collectionPointerChanges.get();
            changedPointers.put(ownerUUID, pointer);
        }
        return pointer;
    }

    protected OSBTreeBonsaiLocal<OIdentifiable, Integer> createTree(int clusterId) {
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>("collections_" + clusterId, ".sbc", this.storage);
        tree.create(OLinkSerializer.INSTANCE, OIntegerSerializer.INSTANCE);
        return tree;
    }

    @Override
    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
        String fileName = atomicOperation == null ? this.storage.getWriteCache().fileNameById(collectionPointer.getFileId()) : atomicOperation.fileNameById(collectionPointer.getFileId());
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>(fileName.substring(0, fileName.length() - ".sbc".length()), ".sbc", this.storage);
        tree.load(collectionPointer.getRootPointer());
        return tree;
    }

    @Override
    public UUID listenForChanges(ORidBag collection) {
        UUID ownerUUID = collection.getTemporaryId();
        if (ownerUUID != null) {
            OBonsaiCollectionPointer pointer = collection.getPointer();
            Map<UUID, OBonsaiCollectionPointer> changedPointers = this.collectionPointerChanges.get();
            changedPointers.put(ownerUUID, pointer);
        }
        return null;
    }

    @Override
    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
    }

    @Override
    public void clearPendingCollections() {
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        return this.collectionPointerChanges.get();
    }

    @Override
    public void clearChangedIds() {
        this.collectionPointerChanges.get().clear();
    }

    private static class CollectionPointerChangesThreadLocal
    extends ThreadLocal<Map<UUID, OBonsaiCollectionPointer>> {
        private CollectionPointerChangesThreadLocal() {
        }

        @Override
        protected Map<UUID, OBonsaiCollectionPointer> initialValue() {
            return new HashMap<UUID, OBonsaiCollectionPointer>();
        }
    }
}

