/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;

public abstract class OCoreException
extends OException {
    private OErrorCode errorCode;
    private final String storageURL;
    private final String componentName;

    public OCoreException(OCoreException exception) {
        super(exception);
        this.storageURL = exception.storageURL;
        this.componentName = exception.componentName;
    }

    public OCoreException(String message) {
        this(message, null, null);
    }

    public OCoreException(String message, String componentName) {
        this(message, componentName, null);
    }

    public OCoreException(String message, String componentName, OErrorCode errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.componentName = componentName != null ? componentName : null;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        this.storageURL = database != null ? database.getURL() : null;
    }

    public OErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getStorageURL() {
        return this.storageURL;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public final String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        if (this.storageURL != null) {
            builder.append("\r\n\t").append("Storage URL=\"").append(this.storageURL).append("\"");
        }
        if (this.componentName != null) {
            builder.append("\r\n\t").append("Component Name=\"").append(this.componentName).append("\"");
        }
        if (this.errorCode != null) {
            builder.append("\r\n\t").append("Error Code=\"").append(this.errorCode.getCode()).append("\"");
        }
        return builder.toString();
    }
}

